/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.reporting.BuildInfo;
import com.google.caja.service.CajolingService;
import com.google.caja.service.CajolingServlet;
import com.google.caja.util.CajaTestCase;
import javax.servlet.Servlet;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.handler.ResourceHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;

public abstract class BrowserTestCase
extends CajaTestCase {
    protected Server server;

    protected void StartLocalServer() {
        this.server = new Server(this.portNumber());
        ResourceHandler resource_handler = new ResourceHandler();
        resource_handler.setResourceBase(".");
        String subdir = "/caja";
        ContextHandler caja = new ContextHandler("/caja");
        String service = "/cajole";
        ResourceHandler caja_static = new ResourceHandler();
        caja_static.setResourceBase("./ant-war/");
        Context servlets = new Context((HandlerContainer)this.server, "/", 0);
        servlets.addServlet(new ServletHolder((Servlet)new CajolingServlet(new CajolingService(BuildInfo.getInstance(), "http://localhost:" + this.portNumber() + "/caja" + "/cajole"))), "/cajole");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{caja_static, servlets, new DefaultHandler()});
        caja.setHandler((Handler)handlers);
        HandlerList handlers2 = new HandlerList();
        handlers2.setHandlers(new Handler[]{resource_handler, caja, new DefaultHandler()});
        this.server.setHandler((Handler)handlers2);
        try {
            this.server.start();
        }
        catch (Exception e) {
            BrowserTestCase.fail((String)"Starting the local web server failed!");
        }
    }

    protected void StopLocalServer() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int portNumber() {
        return 8000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runBrowserTest(String pageName) {
        if (this.checkHeadless()) {
            return;
        }
        this.StartLocalServer();
        try {
            FirefoxDriver driver = new FirefoxDriver();
            driver.get("http://localhost:8000/ant-lib/com/google/caja/plugin/" + pageName);
            this.driveBrowser((WebDriver)driver, pageName);
            driver.quit();
        }
        finally {
            this.StopLocalServer();
        }
    }

    protected abstract void driveBrowser(WebDriver var1, String var2);

    public static void poll(int timeoutMillis, int intervalMillis, Check c) {
        int rounds;
        int limit = timeoutMillis / intervalMillis;
        for (rounds = 0; rounds < limit && !c.run(); ++rounds) {
            try {
                Thread.sleep(intervalMillis);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        BrowserTestCase.assertTrue((String)(timeoutMillis + " ms passed while waiting for: " + c + "."), (rounds < limit ? 1 : 0) != 0);
    }

    public static interface Check {
        public boolean run();
    }
}

