/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.TranslatedCode;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.CajitaRewriter;
import com.google.caja.parser.quasiliteral.DefaultValijaRewriter;
import com.google.caja.parser.quasiliteral.ES53Rewriter;
import com.google.caja.parser.quasiliteral.IllegalReferenceCheckRewriter;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.parser.quasiliteral.NonAsciiCheckVisitor;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import java.net.URI;

public class ExpressionSanitizerCaja {
    private final ModuleManager mgr;
    private final URI baseUri;

    public ExpressionSanitizerCaja(ModuleManager mgr, URI baseUri) {
        this.mgr = mgr;
        this.baseUri = baseUri;
    }

    public ParseTreeNode sanitize(ParseTreeNode input) {
        return this.sanitize(input, false);
    }

    public ParseTreeNode sanitize(ParseTreeNode input, boolean useSES) {
        Block body;
        MessageQueue mq = this.mgr.getMessageQueue();
        ParseTreeNode result = null;
        if (input instanceof UncajoledModule && (body = ((UncajoledModule)input).getModuleBody()).children().size() == 2 && body.children().get(0) instanceof DirectivePrologue && ((DirectivePrologue)body.children().get(0)).hasDirective("use strict") && body.children().get(1) instanceof TranslatedCode) {
            result = input;
        }
        if (useSES) {
            result = this.newES53Rewriter().expand(input);
        } else {
            if (result == null) {
                result = this.newValijaRewriter(mq).expand(input);
            }
            if (!mq.hasMessageAtLevel(MessageLevel.ERROR)) {
                result = this.newCajitaRewriter(this.mgr).expand(result);
            }
        }
        if (!mq.hasMessageAtLevel(MessageLevel.ERROR)) {
            result = new IllegalReferenceCheckRewriter(mq, false).expand(result);
            if (!mq.hasMessageAtLevel(MessageLevel.ERROR)) {
                result.acceptPreOrder(new NonAsciiCheckVisitor(mq), null);
            }
        }
        return result;
    }

    protected Rewriter newCajitaRewriter(ModuleManager mgr) {
        return new CajitaRewriter(this.baseUri, mgr, false);
    }

    protected Rewriter newES53Rewriter() {
        return new ES53Rewriter(this.baseUri, this.mgr, false);
    }

    protected Rewriter newValijaRewriter(MessageQueue mq) {
        return new DefaultValijaRewriter(mq, false);
    }
}

