/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.stages.ConsolidateCodeStage;
import com.google.caja.plugin.stages.DebuggingSymbolsStage;
import com.google.caja.plugin.stages.InferFilePositionsStage;
import com.google.caja.plugin.stages.ValidateJavascriptStage;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Executor;
import com.google.caja.util.FailureIsAnOption;
import com.google.caja.util.Pipeline;
import com.google.caja.util.RhinoTestBed;

public class DebuggingSymbolsStageTest
extends CajaTestCase {
    public final void testDereferenceNull() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\nvar x = null;\nvar xDotFoo = (x).foo;", "testDereferenceNull:4+16 - 22");
    }

    public final void testCallOnNullObject() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\n{\n  function f(x) { return x.foo(); }\n  function g() { return f(null); }\n\n  g();\n}", "testCallOnNullObject:7+3 - 4\ntestCallOnNullObject:5+25 - 26\ntestCallOnNullObject:4+26 - 31");
    }

    public final void testCallUndefinedMethod() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\n{\n  function f(x) { return x.noSuchMethod(); }\n  function g() { return f(new Date); }\n\n  g();\n}", "testCallUndefinedMethod:7+3 - 4\ntestCallUndefinedMethod:5+25 - 26\ntestCallUndefinedMethod:4+26 - 40");
    }

    public final void testReflectiveInvocation() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\nDate.call({}, 4);\n", "testReflectiveInvocation:3+1 - 16");
        this.assertStackTrace("'use strict';\n'use cajita';\nDate.apply({}, 4);\n", "testReflectiveInvocation:3+1 - 17");
    }

    public final void testInaccessibleProperty() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\n{\n  function f(x, k) { return x['foo_'] = 0; }\n  f(new Date);\n}", "testInaccessibleProperty:5+3 - 4\ntestInaccessibleProperty:4+29 - 42");
    }

    public final void testSetOfNullObject() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\n(null).x = 0;", "testSetOfNullObject:3+2 - 13");
    }

    public final void testDeleteOfNullObject() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\n{ delete (null).x; }", "testDeleteOfNullObject:3+3 - 18");
    }

    public final void testSetOfFrozenObject() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\nvar o = cajita.freeze({ x: 1 });\n(null).x = 0;", "testSetOfFrozenObject:4+2 - 13");
    }

    public final void testDeleteOfFrozenObject() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\nvar o = cajita.freeze({ x: 1 });\ndelete (null).x;", "testDeleteOfFrozenObject:4+1 - 16");
    }

    @FailureIsAnOption
    public final void testEnumerateOfNull() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\n{\n  (function () {\n    var myObj = null;\n    for (var k in myObj) {\n      ;\n    }\n  })();\n}", "testEnumerateOfNull:4+4 - 9+4\ntestEnumerateOfNull:6+19 - 24");
    }

    public final void testPropertyInNull() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\n(function (x) {\n  return 'k' in x;\n})(null);", "testPropertyInNull:3+2 - 5+2\ntestPropertyInNull:4+10 - 18");
    }

    public final void testConstruction() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\nvar foo = function () { throw new Error('hi'); };\nnew foo();", "testConstruction:4+1 - 10\ntestConstruction:3+25 - 46");
    }

    public final void testIllegalAccessInsideHoistedFunction() throws Exception {
        this.assertStackTrace("'use strict';\n'use cajita';\nvar x = true;\nvar foo = {};\nif (x) {\n  var y = 5;\n  function f() {\n    var x = 'y___';\n    foo[x] = 1;\n  }\n}\nnew f();", "testIllegalAccessInsideHoistedFunction:12+1 - 8\ntestIllegalAccessInsideHoistedFunction:9+5 - 15");
    }

    public final void testWrappedConstructors() throws Exception {
        this.assertConsistent("new Date(0).toString()");
        this.assertConsistent("new Array(4).length");
        this.assertConsistent("new Array('4.1').length");
        this.assertConsistent("new Array(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15).length");
        this.assertConsistent("(new RegExp('foo', 'i')).test('foobar')");
        this.assertConsistent("(function () {\n  function sum(nums) {\n    var n = 0;\n    for (var i = nums.length; --i >= 0;) { n += nums[i]; }\n    return n;\n  }\n  function Clazz() {\n    var x = sum(arguments);\n    return { get: function() { return x; } };\n  }\n  var c = new Clazz(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16);\n  return c.get() + ',' + (c instanceof Clazz);\n})()");
        this.assertConsistent("(function () {\n  function sum(nums) {\n    var n = 0;\n    for (var i = nums.length; --i >= 0;) { n += nums[i]; }\n    return n;\n  }\n  function Clazz() {\n    var x = sum(arguments);\n    return { get: function() { return x; } };\n  }\n  function Factory (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) {\n    return new Clazz(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);\n  }\n  var c = new Factory(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16);\n  return c.get() + ',' + (c instanceof Clazz);\n})()");
    }

    private void assertStackTrace(String js, String golden) throws Exception {
        this.runCajoled(js, golden, "var stack = '<no-stack>';                              try {                                                  %s                                                 } catch (e) {                                          stack = e.cajitaStack___;                            if (!stack) { throw e; }                             stack = stack.join('\\n');  }                                                    stack                                               ");
    }

    private void assertConsistent(String js) throws Exception {
        Object golden = RhinoTestBed.runJs(new Executor.Input(((Object)((Object)this)).getClass(), "/js/json_sans_eval/json_sans_eval.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/cajita.js"), new Executor.Input(js, this.getName()));
        this.runCajoled("'use strict';\n'use cajita';\nresult(" + js + ");", golden, "  var output = '<no-output>';___.getNewModuleHandler().getImports().result =     ___.markFuncFreeze(function (x) { output = x; });%s;output");
    }

    private void runCajoled(String js, Object golden, String context) throws Exception {
        Block uncajoledModuleBody = this.js(this.fromString(js));
        System.err.println("\n\nblock\n=====\n" + uncajoledModuleBody.toStringDeep(1));
        Jobs jobs = new Jobs(this.mc, this.mq, new PluginMeta());
        jobs.getJobs().add(Job.jsJob(null, uncajoledModuleBody, null));
        Pipeline<Jobs> pipeline = new Pipeline<Jobs>();
        TestBuildInfo buildInfo = TestBuildInfo.getInstance();
        ModuleManager mgr = new ModuleManager(buildInfo, UriFetcher.NULL_NETWORK, false, this.mq);
        pipeline.getStages().add(new ValidateJavascriptStage(mgr));
        pipeline.getStages().add(new ConsolidateCodeStage(mgr));
        pipeline.getStages().add(new InferFilePositionsStage());
        pipeline.getStages().add(new DebuggingSymbolsStage());
        if (!pipeline.apply(jobs)) {
            StringBuilder sb = new StringBuilder();
            for (Message msg : this.mq.getMessages()) {
                if (0 == sb.length()) {
                    sb.append('\n');
                }
                sb.append((Object)msg.getMessageLevel()).append(": ");
                msg.format(this.mc, sb);
            }
            DebuggingSymbolsStageTest.fail((String)sb.toString());
        }
        CajoledModule cajoledModule = (CajoledModule)jobs.getJobs().get(0).getRoot();
        try {
            String cajoledText = String.format(context, DebuggingSymbolsStageTest.render(cajoledModule));
            Object actual = RhinoTestBed.runJs(new Executor.Input(((Object)((Object)this)).getClass(), "/js/json_sans_eval/json_sans_eval.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../console-stubs.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/cajita.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/log-to-console.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/cajita-debugmode.js"), new Executor.Input(cajoledText, this.getName()));
            DebuggingSymbolsStageTest.assertEquals((Object)golden, (Object)actual);
        }
        catch (Exception ex) {
            System.err.println(DebuggingSymbolsStageTest.render(cajoledModule));
            throw ex;
        }
        catch (Error ex) {
            System.err.println(DebuggingSymbolsStageTest.render(cajoledModule));
            throw ex;
        }
    }
}

