/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.NumberLiteral;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.plugin.templates.Part;
import com.google.caja.plugin.templates.SideEffectPart;
import com.google.caja.plugin.templates.StringPart;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.reporting.RenderContext;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Emitter {
    final List<Part> parts;

    Emitter(List<Part> parts) {
        this.parts = parts;
    }

    Expression toExpression(boolean mustBeString) {
        this.moveSideEffectsBack();
        this.foldAdjacentStringLiterals();
        this.foldSideEffectsIntoStringPart(true);
        this.checkThatOneOperandIsStringLike(mustBeString);
        if (this.parts.isEmpty()) {
            return StringLiteral.valueOf(FilePosition.UNKNOWN, "");
        }
        Expression e = null;
        for (Part p : this.parts) {
            Expression pe;
            if (p instanceof StringPart) {
                pe = ((StringPart)p).e;
            } else if (p instanceof SideEffectPart) {
                SideEffectPart sep = (SideEffectPart)p;
                FilePosition epos = sep.e.getFilePosition();
                pe = Operation.createInfix(Operator.COMMA, sep.e, StringLiteral.valueOf(epos, ""));
            } else {
                throw new IllegalStateException();
            }
            if (e != null) {
                e = Operation.createInfix(Operator.ADDITION, e, pe);
                continue;
            }
            e = pe;
        }
        return e;
    }

    private void moveSideEffectsBack() {
        ArrayList<Part> newParts = new ArrayList<Part>();
        ArrayList<StringPart> stringParts = new ArrayList<StringPart>();
        for (Part p : this.parts) {
            if (p instanceof StringPart) {
                if (((StringPart)p).e instanceof Literal) {
                    stringParts.add((StringPart)p);
                    continue;
                }
            } else if (p instanceof SideEffectPart && ((SideEffectPart)p).canReorder) {
                newParts.add(p);
                continue;
            }
            newParts.addAll(stringParts);
            stringParts.clear();
            newParts.add(p);
        }
        newParts.addAll(stringParts);
        stringParts = null;
        this.parts.clear();
        SideEffectPart lastSep = null;
        for (Part p : newParts) {
            if (p instanceof SideEffectPart) {
                SideEffectPart sep = (SideEffectPart)p;
                lastSep = lastSep == null ? sep : new SideEffectPart(Operation.createInfix(Operator.COMMA, lastSep.e, sep.e), lastSep.canReorder && sep.canReorder);
                continue;
            }
            if (lastSep != null) {
                this.parts.add(lastSep);
                lastSep = null;
            }
            this.parts.add(p);
        }
        if (lastSep != null) {
            this.parts.add(lastSep);
        }
    }

    private void foldAdjacentStringLiterals() {
        int i = this.parts.size();
        while (--i >= 0) {
            int j;
            Part p = this.parts.get(i);
            if (!(p instanceof StringPart)) continue;
            StringPart sp = (StringPart)p;
            if (!(sp.e instanceof StringLiteral)) continue;
            for (j = i; j > 0 && Emitter.isStringLiteralPart(this.parts.get(j - 1)); --j) {
            }
            if (i == j) continue;
            List<Part> toFold = this.parts.subList(j, i + 1);
            i = j;
            StringBuilder sb = new StringBuilder();
            for (Part tf : toFold) {
                sb.append(((StringLiteral)((StringPart)tf).e).getUnquotedValue());
            }
            StringPart first = (StringPart)toFold.get(0);
            StringPart last = (StringPart)toFold.get(toFold.size() - 1);
            FilePosition pos = FilePosition.span(first.e.getFilePosition(), last.e.getFilePosition());
            toFold.clear();
            toFold.add(new StringPart(StringLiteral.valueOf(pos, sb.toString())));
        }
    }

    private static boolean isStringLiteralPart(Part p) {
        return p instanceof StringPart && ((StringPart)p).e instanceof StringLiteral;
    }

    private void foldSideEffectsIntoStringPart(boolean alwaysFold) {
        int i = this.parts.size();
        while (--i >= 0) {
            Part pp;
            Part p = this.parts.get(i);
            if (!(p instanceof SideEffectPart)) continue;
            SideEffectPart sep = (SideEffectPart)p;
            Part np = i + 1 < this.parts.size() ? this.parts.get(i + 1) : null;
            Part part = pp = i > 0 ? this.parts.get(i - 1) : null;
            if (np instanceof StringPart && (alwaysFold || pp instanceof StringPart)) {
                Expression se = ((StringPart)np).e;
                StringPart combined = new StringPart(Operation.create(FilePosition.UNKNOWN, Operator.COMMA, sep.e, se));
                List<Part> both = this.parts.subList(i, i + 2);
                both.clear();
                both.add(combined);
                continue;
            }
            if (!alwaysFold) continue;
            FilePosition pos = sep.e.getFilePosition();
            this.parts.set(i, new StringPart(Operation.create(pos, Operator.COMMA, sep.e, new StringLiteral(FilePosition.endOf(pos), ""))));
        }
    }

    private void checkThatOneOperandIsStringLike(boolean mustBeString) {
        switch (this.parts.size()) {
            case 0: {
                return;
            }
            case 1: {
                if (mustBeString && !Emitter.isStringy(this.parts.get(0), true)) break;
                return;
            }
            default: {
                if (!Emitter.isStringy(this.parts.get(0), false) && !Emitter.isStringy(this.parts.get(1), false)) break;
                return;
            }
        }
        Expression e = ((StringPart)this.parts.get((int)0)).e;
        this.parts.set(0, new StringPart(Emitter.makeStringy(e, this.parts.size() == 1)));
    }

    static boolean isStringy(Part p, boolean strict) {
        return p instanceof StringPart && Emitter.isStringy(((StringPart)p).e, strict);
    }

    static boolean isStringy(Expression e, boolean strict) {
        if (e instanceof StringLiteral) {
            return true;
        }
        if (e instanceof Operation) {
            Operation op = (Operation)e;
            List<? extends Expression> operands = op.children();
            switch (op.getOperator()) {
                case ADDITION: {
                    return Emitter.isStringy(operands.get(0), false) || Emitter.isStringy(operands.get(1), false);
                }
                case TERNARY: 
                case LOGICAL_AND: 
                case LOGICAL_OR: {
                    return Emitter.isStringy(operands.get(operands.size() - 2), strict) && Emitter.isStringy(operands.get(operands.size() - 1), strict);
                }
                case COMMA: {
                    return Emitter.isStringy(operands.get(operands.size() - 1), strict);
                }
                case CONSTRUCTOR: {
                    return !strict;
                }
                case FUNCTION_CALL: {
                    return !strict && Emitter.is(operands.get(0), Operator.CONSTRUCTOR);
                }
            }
            return false;
        }
        if (e instanceof ArrayConstructor || e instanceof FunctionConstructor || e instanceof ObjectConstructor) {
            return !strict;
        }
        return false;
    }

    static Expression makeStringy(Expression e, boolean strict) {
        if (Emitter.isStringy(e, strict)) {
            return e;
        }
        Operation stringier = null;
        if (e instanceof Operation) {
            Operation op = (Operation)e;
            List<? extends Expression> operands = op.children();
            switch (op.getOperator()) {
                case TERNARY: {
                    stringier = Operation.create(e.getFilePosition(), Operator.TERNARY, operands.get(0), Emitter.makeStringy(operands.get(1), strict), Emitter.makeStringy(operands.get(2), strict));
                    break;
                }
                case COMMA: {
                    stringier = Operation.create(e.getFilePosition(), Operator.COMMA, operands.get(0), Emitter.makeStringy(operands.get(1), strict));
                    break;
                }
            }
        }
        if (stringier == null) {
            stringier = Operation.createInfix(Operator.ADDITION, StringLiteral.valueOf(FilePosition.startOf(e.getFilePosition()), ""), e);
        }
        assert (Emitter.isStringy(stringier, strict));
        return stringier;
    }

    static boolean is(Expression e, Operator op) {
        return e instanceof Operation && op == ((Operation)e).getOperator();
    }

    static boolean isStringConcat(Expression e) {
        if (!Emitter.is(e, Operator.ADDITION)) {
            return false;
        }
        Operation op = (Operation)e;
        return Emitter.isStringy(op.children().get(0), false) || Emitter.isStringy(op.children().get(1), false);
    }

    static String asString(Literal l) {
        if (l instanceof NumberLiteral) {
            return NumberLiteral.numberToString(((NumberLiteral)l).doubleValue());
        }
        StringBuilder sb = new StringBuilder();
        JsMinimalPrinter p = new JsMinimalPrinter(new Concatenator(sb));
        l.render(new RenderContext(p));
        p.noMoreTokens();
        return sb.toString();
    }

    static StringLiteral asStringLiteral(Expression e) {
        Expression child;
        if (e instanceof Literal) {
            if (e instanceof StringLiteral) {
                return (StringLiteral)e;
            }
            return StringLiteral.valueOf(e.getFilePosition(), Emitter.asString((Literal)e));
        }
        if (Emitter.is(e, Operator.NEGATION) && (child = ((Operation)e).children().get(0)) instanceof NumberLiteral) {
            return StringLiteral.valueOf(e.getFilePosition(), "-" + Emitter.asString((Literal)child));
        }
        return null;
    }
}

