/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.service.ServiceTestCase;

public class JsHandlerTest
extends ServiceTestCase {
    private static String normStringSpaces(String s) {
        return s.replaceAll("[ \r\n\t]+", " ").replaceAll("^ | $|(?<=\\W) | (?=\\W)", "");
    }

    protected void assertEqualsIgnoreSpace(String expected, String actual) {
        JsHandlerTest.assertEquals((String)JsHandlerTest.normStringSpaces(expected), (String)JsHandlerTest.normStringSpaces(actual));
    }

    public final void testSimpleJs() throws Exception {
        this.registerUri("http://foo/bar.js", "g(1);", "text/javascript");
        this.assertEqualsIgnoreSpace(JsHandlerTest.valijaModule("moduleResult___ = $v.cf($v.ro('g'), [ 1 ]);"), (String)this.requestGet("?url=http://foo/bar.js&mime-type=text/javascript&transform=CAJOLE"));
    }

    public final void testAltJscriptMimeType() throws Exception {
        this.registerUri("http://foo/bar.js", "f();", "application/x-javascript");
        this.assertEqualsIgnoreSpace(JsHandlerTest.valijaModule("moduleResult___ = $v.cf($v.ro('f'), [ ]);"), (String)this.requestGet("?url=http://foo/bar.js&mime-type=text/javascript&transform=CAJOLE"));
    }

    public final void testJsWithCallback() throws Exception {
        this.registerUri("http://foo/bar.js", "g(1);", "text/javascript");
        this.assertEqualsIgnoreSpace(JsHandlerTest.valijaModuleWithCallback("foo.bar.baz", "moduleResult___ = $v.cf($v.ro('g'), [ 1 ]);"), (String)this.requestGet("?url=http://foo/bar.js&mime-type=text/javascript&transform=CAJOLE&module-callback=foo.bar.baz"));
    }

    public final void testSimpleCajitaJs() throws Exception {
        this.registerUri("http://foo/bar.js", "g(1);", "text/javascript");
        this.assertEqualsIgnoreSpace(JsHandlerTest.cajitaModule("var g=___.readImport(IMPORTS___,'g');", "moduleResult___=g.CALL___(1);"), (String)this.requestGet("?url=http://foo/bar.js&mime-type=text/javascript&transform=CAJOLE&directive=CAJITA"));
    }
}

