/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.rest.FieldInjector;
import org.exoplatform.services.rest.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencySupplier {
    protected final Class<? extends Annotation> injectAnnotationClass;

    protected DependencySupplier(Class<? extends Annotation> injectAnnotationClass) {
        this.injectAnnotationClass = injectAnnotationClass;
    }

    public DependencySupplier() {
        this(Inject.class);
    }

    public DependencySupplier(InitParams params) {
        this(DependencySupplier.findInjectAnnotationClass(params));
    }

    private static Class<? extends Annotation> findInjectAnnotationClass(InitParams params) {
        Class injectAnnotationClass = null;
        if (params != null) {
            final ValueParam injectAnnotationParameter = params.getValueParam("inject.annotation.class");
            try {
                injectAnnotationClass = (Class)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Class>(){

                    @Override
                    public Class run() throws ClassNotFoundException {
                        return Thread.currentThread().getContextClassLoader().loadClass(injectAnnotationParameter.getValue());
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                ClassNotFoundException c = (ClassNotFoundException)pe.getCause();
                throw new RuntimeException(c.getMessage());
            }
        }
        if (injectAnnotationClass == null) {
            injectAnnotationClass = Inject.class;
        }
        return injectAnnotationClass;
    }

    public final Object getComponent(Parameter parameter) {
        if (parameter instanceof FieldInjector) {
            for (Annotation a : parameter.getAnnotations()) {
                if (!this.injectAnnotationClass.isInstance(a)) continue;
                return this.getComponent(parameter.getParameterClass(), parameter.getGenericType());
            }
            return null;
        }
        return this.getComponent(parameter.getParameterClass(), parameter.getGenericType());
    }

    protected Object getComponent(Class<?> parameterClass, Type genericType) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        List injectionProviders = container.getComponentInstancesOfType(Provider.class);
        if (injectionProviders != null && injectionProviders.size() > 0) {
            for (Provider provider : injectionProviders) {
                ParameterizedType pType;
                Type rawType;
                Type injectedType = this.resolveInjectedType(provider.getClass());
                if (injectedType == null) continue;
                if (Provider.class == parameterClass) {
                    Type actualType;
                    Type[] parameterActualTypes;
                    if (!(genericType instanceof ParameterizedType) || (parameterActualTypes = ((ParameterizedType)genericType).getActualTypeArguments()).length <= 0 || !(parameterActualTypes[0] instanceof Class ? (actualType = (Class)parameterActualTypes[0]) == injectedType : parameterActualTypes[0] instanceof ParameterizedType && (actualType = (ParameterizedType)parameterActualTypes[0]).equals(injectedType))) continue;
                    return provider;
                }
                if (!(injectedType instanceof Class ? parameterClass.isAssignableFrom((Class)injectedType) : injectedType instanceof ParameterizedType && (rawType = (pType = (ParameterizedType)injectedType).getRawType()) instanceof Class && parameterClass.isAssignableFrom((Class)rawType))) continue;
                return provider.get();
            }
        }
        if (!Provider.class.isAssignableFrom(parameterClass)) {
            return container.getComponentInstanceOfType(parameterClass);
        }
        return null;
    }

    private Type resolveInjectedType(final Class<?> providerClass) {
        Method get = null;
        Type injectedType = null;
        try {
            get = (Method)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws NoSuchMethodException {
                    return providerClass.getMethod("get", new Class[0]);
                }
            });
        }
        catch (PrivilegedActionException pe) {
            NoSuchMethodException c = (NoSuchMethodException)pe.getCause();
            throw new RuntimeException(c.getMessage());
        }
        if (get != null) {
            injectedType = get.getGenericReturnType();
        }
        return injectedType;
    }
}

