/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.persist.Crypto;
import org.hsqldb.result.Result;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptReaderDecode;
import org.hsqldb.scriptio.ScriptReaderText;

public class ScriptRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runScript(Database database, String string) {
        IntKeyHashMap intKeyHashMap = new IntKeyHashMap();
        Session session = null;
        int n = 0;
        database.setReferentialIntegrity(false);
        ScriptReaderBase scriptReaderBase = null;
        StatementDML statementDML = new StatementDML(81, 2004, null);
        try {
            StopWatch stopWatch = new StopWatch();
            Crypto crypto = database.logger.getCrypto();
            scriptReaderBase = crypto == null ? new ScriptReaderText(database, string) : new ScriptReaderDecode(database, string, crypto, true);
            while (scriptReaderBase.readLoggedStatement(session)) {
                int n2 = scriptReaderBase.getSessionNumber();
                if ((session == null || n != n2) && (session = (Session)intKeyHashMap.get(n = n2)) == null) {
                    session = database.getSessionManager().newSession(database, database.getUserManager().getSysUser(), false, true, null, 0);
                    intKeyHashMap.put(n, session);
                }
                if (session.isClosed()) {
                    intKeyHashMap.remove(n);
                    continue;
                }
                Result result = null;
                int n3 = scriptReaderBase.getStatementType();
                switch (n3) {
                    case 1: {
                        String string2 = scriptReaderBase.getLoggedStatement();
                        result = session.executeDirectStatement(string2, 0);
                        if (result == null || !result.isError()) break;
                        if (result.getException() != null) {
                            throw result.getException();
                        }
                        throw Error.error(result);
                    }
                    case 4: {
                        session.commit(false);
                        break;
                    }
                    case 3: {
                        session.sessionContext.currentStatement = statementDML;
                        session.beginAction(statementDML);
                        Object[] objectArray = scriptReaderBase.getData();
                        scriptReaderBase.getCurrentTable().insertNoCheckFromLog(session, objectArray);
                        session.endAction(Result.updateOneResult);
                        break;
                    }
                    case 2: {
                        session.sessionContext.currentStatement = statementDML;
                        session.beginAction(statementDML);
                        Object[] objectArray = scriptReaderBase.getData();
                        scriptReaderBase.getCurrentTable().deleteNoCheckFromLog(session, objectArray);
                        session.endAction(Result.updateOneResult);
                        break;
                    }
                    case 6: {
                        Object[] objectArray = database.schemaManager.findSchemaHsqlName(scriptReaderBase.getCurrentSchema());
                        session.setCurrentSchemaHsqlName((HsqlNameManager.HsqlName)objectArray);
                        break;
                    }
                }
                if (!session.isClosed()) continue;
                intKeyHashMap.remove(n);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof EOFException) {
            } else {
                if (throwable instanceof OutOfMemoryError) {
                    database.logger.logSevereEvent("out of memory processing " + string + " line: " + scriptReaderBase.getLineNumber(), throwable);
                    throw Error.error(460);
                }
                database.logger.logSevereEvent(string + " line: " + scriptReaderBase.getLineNumber(), throwable);
            }
        }
        finally {
            if (scriptReaderBase != null) {
                scriptReaderBase.close();
            }
            database.getSessionManager().closeAllSessions();
            database.setReferentialIntegrity(true);
        }
    }
}

