/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipTypeEventListener;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.OrganizationServiceInitializer;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.picocontainer.Startable;

public abstract class BaseOrganizationService
implements OrganizationService,
Startable,
ComponentRequestLifecycle {
    protected UserHandler userDAO_;
    protected UserProfileHandler userProfileDAO_;
    protected GroupHandler groupDAO_;
    protected MembershipHandler membershipDAO_;
    protected MembershipTypeHandler membershipTypeDAO_;
    protected List<OrganizationServiceInitializer> listeners_ = new ArrayList<OrganizationServiceInitializer>(3);

    public UserHandler getUserHandler() {
        return this.userDAO_;
    }

    public UserProfileHandler getUserProfileHandler() {
        return this.userProfileDAO_;
    }

    public GroupHandler getGroupHandler() {
        return this.groupDAO_;
    }

    public MembershipTypeHandler getMembershipTypeHandler() {
        return this.membershipTypeDAO_;
    }

    public MembershipHandler getMembershipHandler() {
        return this.membershipDAO_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        try {
            RequestLifeCycle.begin((ComponentRequestLifecycle)this);
            for (OrganizationServiceInitializer listener : this.listeners_) {
                try {
                    listener.init(this);
                }
                catch (Exception ex) {
                    String msg = "Failed start Organization Service " + this.getClass().getName() + ", probably because of configuration error. Error occurs when initialize " + listener.getClass().getName();
                    throw new RuntimeException(msg, ex);
                    return;
                }
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }

    public synchronized void addListenerPlugin(ComponentPlugin listener) throws Exception {
        if (listener instanceof UserEventListener) {
            this.userDAO_.addUserEventListener((UserEventListener)listener);
        } else if (listener instanceof GroupEventListener) {
            this.groupDAO_.addGroupEventListener((GroupEventListener)listener);
        } else if (listener instanceof MembershipTypeEventListener) {
            this.membershipTypeDAO_.addMembershipTypeEventListener((MembershipTypeEventListener)listener);
        } else if (listener instanceof MembershipEventListener) {
            this.membershipDAO_.addMembershipEventListener((MembershipEventListener)listener);
        } else if (listener instanceof UserProfileEventListener) {
            this.userProfileDAO_.addUserProfileEventListener((UserProfileEventListener)listener);
        } else if (listener instanceof OrganizationServiceInitializer) {
            this.listeners_.add((OrganizationServiceInitializer)listener);
        } else {
            throw new RuntimeException(listener.getClass().getName() + " is an unknown listener type");
        }
    }

    public void startRequest(ExoContainer container) {
    }

    public void endRequest(ExoContainer container) {
    }
}

