/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.impl.mock;

import java.util.Collection;
import java.util.Iterator;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.Membership;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMembershipListAccess
implements ListAccess<Membership> {
    private final Collection<Membership> memberships;

    public SimpleMembershipListAccess(Collection<Membership> memberships) {
        this.memberships = memberships;
    }

    public Membership[] load(int index, int length) throws Exception, IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: can't be a negative number");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length: can't be a negative number");
        }
        if (index + length > this.memberships.size()) {
            throw new IllegalArgumentException("The sum of the index and the length cannot be greater than the list size");
        }
        Membership[] results = new Membership[length];
        Iterator<Membership> iter = this.memberships.iterator();
        int p = 0;
        int counter = 0;
        while (counter < length) {
            Membership membership = iter.next();
            if (p >= index) {
                results[counter++] = membership;
            }
            ++p;
        }
        return results;
    }

    public int getSize() throws Exception {
        return this.memberships.size();
    }
}

