/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.oauth.OAuthClientState;
import org.apache.shindig.gadgets.oauth.OAuthRequestException;

public class OAuthResponseParams {
    private static final Logger LOG = Logger.getLogger(OAuthResponseParams.class.getName());
    private static final Pattern REMOVE_SECRETS = Pattern.compile("(?<=(oauth_token_secret|oauth_session_handle)=)[^=& \t\r\n]*");
    public static final String CLIENT_STATE = "oauthState";
    public static final String APPROVAL_URL = "oauthApprovalUrl";
    public static final String ERROR_CODE = "oauthError";
    public static final String ERROR_TEXT = "oauthErrorText";
    private final OAuthClientState newClientState;
    private final SecurityToken securityToken;
    private final HttpRequest originalRequest;
    private final List<Pair<HttpRequest, HttpResponse>> requestTrace = Lists.newArrayList();
    private String aznUrl;
    private boolean sendTraceToClient;

    public OAuthResponseParams(SecurityToken securityToken, HttpRequest originalRequest, BlobCrypter stateCrypter) {
        this.securityToken = securityToken;
        this.originalRequest = originalRequest;
        this.newClientState = new OAuthClientState(stateCrypter);
    }

    public void logDetailedWarning(String note) {
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, note + '\n' + this.getDetails(null));
        }
    }

    public void logDetailedWarning(String note, Throwable e) {
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, note + '\n' + this.getDetails(e), e);
        }
    }

    public void logDetailedInfo(String note, Throwable e) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, note + '\n' + this.getDetails(e), e);
        }
    }

    public void addRequestTrace(HttpRequest request, HttpResponse response) {
        this.requestTrace.add((Pair<HttpRequest, HttpResponse>)Pair.of((Object)request, (Object)response));
    }

    public boolean sawErrorResponse() {
        for (Pair<HttpRequest, HttpResponse> event : this.requestTrace) {
            if (event.two != null && !((HttpResponse)event.two).isError()) continue;
            return true;
        }
        return false;
    }

    private String getDetails(Throwable e) {
        String error = null;
        if (null != e) {
            if (e instanceof OAuthRequestException) {
                OAuthRequestException reqException = (OAuthRequestException)e;
                error = reqException.getError() + ", " + reqException.getErrorText();
            } else {
                error = e.getMessage();
            }
        }
        return "OAuth error [" + error + "] for application " + this.securityToken.getAppUrl() + ".  Request trace:" + this.getRequestTrace();
    }

    private String getRequestTrace() {
        StringBuilder trace = new StringBuilder();
        trace.append("\n==== Original request:\n");
        trace.append(this.originalRequest);
        trace.append("\n====");
        int i = 1;
        for (Pair<HttpRequest, HttpResponse> event : this.requestTrace) {
            trace.append("\n==== Sent request ").append(i).append(":\n");
            if (event.one != null) {
                trace.append(OAuthResponseParams.filterSecrets(((HttpRequest)event.one).toString()));
            }
            trace.append("\n==== Received response ").append(i).append(":\n");
            if (event.two != null) {
                trace.append(OAuthResponseParams.filterSecrets(((HttpResponse)event.two).toString()));
            }
            trace.append("\n====");
            ++i;
        }
        return trace.toString();
    }

    static String filterSecrets(String in) {
        Matcher m = REMOVE_SECRETS.matcher(in);
        return m.replaceAll("REMOVED");
    }

    public void addToResponse(HttpResponseBuilder response, OAuthRequestException e) {
        if (!this.newClientState.isEmpty()) {
            try {
                response.setMetadata(CLIENT_STATE, this.newClientState.getEncryptedState());
            }
            catch (BlobCrypterException cryptException) {
                throw new RuntimeException(cryptException);
            }
        }
        if (this.aznUrl != null) {
            response.setMetadata(APPROVAL_URL, this.aznUrl);
        }
        if (e != null || this.sendTraceToClient) {
            StringBuilder verboseError = new StringBuilder();
            if (e != null) {
                response.setMetadata(ERROR_CODE, e.getError());
                verboseError.append(e.getErrorText());
            }
            if (this.sendTraceToClient) {
                verboseError.append('\n');
                verboseError.append(this.getRequestTrace());
            }
            response.setMetadata(ERROR_TEXT, verboseError.toString());
        }
    }

    public OAuthClientState getNewClientState() {
        return this.newClientState;
    }

    public String getAznUrl() {
        return this.aznUrl;
    }

    public void setAznUrl(String aznUrl) {
        this.aznUrl = aznUrl;
    }

    public boolean sendTraceToClient() {
        return this.sendTraceToClient;
    }

    public void setSendTraceToClient(boolean sendTraceToClient) {
        this.sendTraceToClient = sendTraceToClient;
    }
}

