/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.parse.SocialDataTags;
import org.apache.shindig.gadgets.preload.PipelineExecutor;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.spec.PipelinedData;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineDataGadgetRewriter
implements GadgetRewriter {
    private static final Logger LOG = Logger.getLogger(PipelineDataGadgetRewriter.class.getName());
    private final PipelineExecutor executor;

    @Inject
    public PipelineDataGadgetRewriter(PipelineExecutor executor) {
        this.executor = executor;
    }

    @Override
    public void rewrite(Gadget gadget, MutableContent content) {
        if (!gadget.getSpec().getModulePrefs().getFeatures().containsKey("opensocial-data")) {
            return;
        }
        Document doc = content.getDocument();
        Map<PipelinedData, Node> pipelineNodes = this.parsePipelinedData(gadget, doc);
        if (pipelineNodes.isEmpty()) {
            return;
        }
        PipelineExecutor.Results results = this.executor.execute(gadget.getContext(), pipelineNodes.keySet());
        for (Map.Entry<PipelinedData, Node> nodeEntry : pipelineNodes.entrySet()) {
            if (results.remainingPipelines.contains(nodeEntry.getKey())) continue;
            Node node = nodeEntry.getValue();
            node.getParentNode().removeChild(node);
            MutableContent.notifyEdit(doc);
        }
        if (!results.keyedResults.isEmpty()) {
            Element head = (Element)DomUtil.getFirstNamedChildNode((Node)doc.getDocumentElement(), (String)"head");
            Element pipelineScript = doc.createElement("script");
            pipelineScript.setAttribute("type", "text/javascript");
            StringBuilder script = new StringBuilder();
            for (Map.Entry<String, ? extends Object> entry : results.keyedResults.entrySet()) {
                String key = entry.getKey();
                content.addPipelinedData(key, entry.getValue());
                script.append("opensocial.data.DataContext.putDataSet(\"").append(key).append("\",").append(JsonSerializer.serialize((Object)entry.getValue())).append(");");
            }
            pipelineScript.appendChild(doc.createTextNode(script.toString()));
            head.appendChild(pipelineScript);
            MutableContent.notifyEdit(doc);
        }
        if (results.remainingPipelines.isEmpty()) {
            gadget.addFeature("opensocial-data-context");
            gadget.removeFeature("opensocial-data");
        }
    }

    Map<PipelinedData, Node> parsePipelinedData(Gadget gadget, Document doc) {
        List<Element> dataTags = SocialDataTags.getTags(doc, "OSData");
        HashMap pipelineNodes = Maps.newHashMap();
        for (Element n : dataTags) {
            try {
                PipelinedData pipelineData = new PipelinedData(n, gadget.getSpec().getUrl());
                pipelineNodes.put(pipelineData, n);
            }
            catch (SpecParserException e) {
                LOG.log(Level.INFO, "Failed to parse preload in " + gadget.getSpec().getUrl(), e);
            }
        }
        return pipelineNodes;
    }

    static class PipelineState {
        public Node node;
        public PipelinedData.Batch batch;

        PipelineState() {
        }
    }
}

