/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;

public final class ServletUtil {
    public static final String REMOTE_ADDR_KEY = "RemoteAddress";
    public static final String DATA_URI_KEY = "dataUri";

    private ServletUtil() {
    }

    public static HttpRequest fromHttpServletRequest(HttpServletRequest servletReq) throws IOException {
        HttpRequest req = new HttpRequest(new UriBuilder(servletReq).toUri());
        Enumeration headerNames = servletReq.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            Object obj = headerNames.nextElement();
            if (!(obj instanceof String)) continue;
            String headerName = (String)obj;
            Enumeration headerValues = servletReq.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                obj = headerValues.nextElement();
                if (!(obj instanceof String)) continue;
                req.addHeader(headerName, (String)obj);
            }
        }
        req.setMethod(servletReq.getMethod());
        if ("POST".equalsIgnoreCase(req.getMethod())) {
            req.setPostBody((InputStream)servletReq.getInputStream());
        }
        req.setParam(REMOTE_ADDR_KEY, servletReq.getRemoteAddr());
        return req;
    }

    public static void setCachingHeaders(HttpResponseBuilder response, int ttl, boolean noProxy) {
        for (Pair header : HttpUtil.getCachingHeadersToSet((int)ttl, (boolean)noProxy)) {
            response.setHeader((String)header.one, (String)header.two);
        }
    }

    public static void copyResponseToServlet(HttpResponse response, HttpServletResponse servletResponse) throws IOException {
        servletResponse.setStatus(response.getHttpStatusCode());
        servletResponse.setContentLength(response.getContentLength());
        for (Map.Entry header : response.getHeaders().entries()) {
            servletResponse.addHeader((String)header.getKey(), (String)header.getValue());
        }
        HttpUtil.setCachingHeaders((HttpServletResponse)servletResponse, (int)((int)(response.getCacheTtl() / 1000L)));
        IOUtils.copy((InputStream)response.getResponse(), (OutputStream)servletResponse.getOutputStream());
    }

    public static Uri validateUrl(Uri urlToValidate) throws GadgetException {
        if (urlToValidate == null) {
            throw new GadgetException(GadgetException.Code.MISSING_PARAMETER, "Missing url param", 400);
        }
        UriBuilder url = new UriBuilder(urlToValidate);
        if (!"http".equals(url.getScheme()) && !"https".equals(url.getScheme())) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Invalid request url scheme in url: " + Utf8UrlCoder.encode((String)urlToValidate.toString()) + "; only \"http\" and \"https\" supported.", 400);
        }
        if (url.getPath() == null || url.getPath().length() == 0) {
            url.setPath("/");
        }
        return url.toUri();
    }

    public static void setXForwardedForHeader(HttpRequest inboundRequest, HttpRequest req) throws GadgetException {
        String forwardedFor = ServletUtil.getXForwardedForHeader(inboundRequest.getHeader("X-Forwarded-For"), inboundRequest.getParam(REMOTE_ADDR_KEY));
        if (forwardedFor != null) {
            req.setHeader("X-Forwarded-For", forwardedFor);
        }
    }

    public static void setXForwardedForHeader(HttpServletRequest inboundRequest, HttpRequest req) throws GadgetException {
        String forwardedFor = ServletUtil.getXForwardedForHeader(inboundRequest.getHeader("X-Forwarded-For"), inboundRequest.getRemoteAddr());
        if (forwardedFor != null) {
            req.setHeader("X-Forwarded-For", forwardedFor);
        }
    }

    private static String getXForwardedForHeader(String origValue, String remoteAddr) {
        if (!StringUtils.isEmpty((String)remoteAddr)) {
            origValue = StringUtils.isEmpty((String)origValue) ? remoteAddr : remoteAddr + ", " + origValue;
        }
        return origValue;
    }

    public static HttpResponse errorResponse(GadgetException e) {
        return new HttpResponseBuilder().setHttpStatusCode(e.getHttpStatusCode()).setResponseString(e.getMessage() != null ? e.getMessage() : "").create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse convertToJsonResponse(HttpResponse response) throws IOException {
        String contentType = response.getHeader("Content-Type");
        if (contentType == null) {
            contentType = "";
        } else if (contentType.contains(";")) {
            contentType = StringUtils.split((String)contentType, (char)';')[0].trim();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.write("{\n  ");
        pw.write(DATA_URI_KEY);
        pw.write(":'data:");
        pw.write(contentType);
        pw.write(";base64;charset=");
        pw.write(response.getEncoding());
        pw.write(",");
        pw.flush();
        Base64InputStream b64input = new Base64InputStream(response.getResponse(), true, 0, null);
        byte[] buf = new byte[1024];
        int read = -1;
        try {
            while ((read = b64input.read(buf, 0, 1024)) > 0) {
                os.write(buf, 0, read);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)b64input);
        }
        pw.write("',\n  ");
        boolean first = true;
        for (Map.Entry<String, String> metaEntry : response.getMetadata().entrySet()) {
            if (DATA_URI_KEY.equals(metaEntry.getKey())) continue;
            if (!first) {
                pw.write(",\n  ");
            }
            first = false;
            pw.write("'");
            pw.write(StringEscapeUtils.escapeJavaScript((String)metaEntry.getKey()).replace("'", "'"));
            pw.write("':'");
            pw.write(StringEscapeUtils.escapeJavaScript((String)metaEntry.getValue()).replace("'", "'"));
            pw.write("'");
        }
        pw.write("\n}");
        pw.flush();
        return new HttpResponseBuilder().setHeader("Content-Type", "application/json").setResponseNoCopy(os.toByteArray()).create();
    }
}

