/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReleaseableIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;

public class LuceneQueryHits
implements QueryHits {
    private final IndexReader reader;
    private final Scorer scorer;
    private final boolean releaseReaderOnClose;

    public LuceneQueryHits(IndexReader reader, IndexSearcher searcher, Query query) throws IOException {
        this(reader, searcher, query, false);
    }

    public LuceneQueryHits(IndexReader reader, IndexSearcher searcher, Query query, boolean releaseReaderOnClose) throws IOException {
        this.reader = reader;
        this.scorer = query.weight((Searcher)searcher).scorer(reader, true, false);
        this.releaseReaderOnClose = releaseReaderOnClose;
    }

    public ScoreNode nextScoreNode() throws IOException {
        if (!this.scorer.next()) {
            return null;
        }
        int doc = this.scorer.doc();
        String uuid = this.reader.document(doc).get(FieldNames.UUID);
        return new ScoreNode(uuid, this.scorer.score(), doc);
    }

    public void close() throws IOException {
        if (this.scorer != null) {
            this.scorer.advance(Integer.MAX_VALUE);
        }
        if (this.releaseReaderOnClose && this.reader != null && this.reader instanceof ReleaseableIndexReader) {
            ((ReleaseableIndexReader)this.reader).release();
        }
    }

    public int getSize() {
        return -1;
    }

    public void skip(int n) throws IOException {
        while (n-- > 0) {
            if (this.nextScoreNode() != null) continue;
            return;
        }
    }
}

