/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.Weight;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrIndexSearcher;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;

public class QueryHitsQuery
extends Query
implements JcrQuery {
    private final QueryHits hits;

    public QueryHitsQuery(QueryHits hits) {
        this.hits = hits;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new QueryHitsQueryWeight(searcher.getSimilarity());
    }

    public String toString(String field) {
        return "QueryHitsQuery";
    }

    public void extractTerms(Set terms) {
    }

    public QueryHits execute(JcrIndexSearcher searcher, SessionImpl session, Sort sort) throws IOException {
        if (sort.getSort().length == 0) {
            return this.hits;
        }
        return null;
    }

    public class QueryHitsQueryScorer
    extends Scorer {
        private final Iterator docs;
        private final Map scores;
        private Integer currentDoc;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected QueryHitsQueryScorer(IndexReader reader, Similarity similarity) throws IOException {
            super(similarity);
            this.scores = new HashMap();
            this.currentDoc = null;
            TreeSet<Integer> sortedDocs = new TreeSet<Integer>();
            try {
                ScoreNode node;
                while ((node = QueryHitsQuery.this.hits.nextScoreNode()) != null) {
                    Object var11_10;
                    String uuid = node.getNodeId();
                    Term id = new Term(FieldNames.UUID, uuid);
                    TermDocs tDocs = reader.termDocs(id);
                    try {
                        if (tDocs.next()) {
                            Integer doc = new Integer(tDocs.doc());
                            sortedDocs.add(doc);
                            this.scores.put(doc, new Float(node.getScore()));
                        }
                        var11_10 = null;
                    }
                    catch (Throwable throwable) {
                        var11_10 = null;
                        tDocs.close();
                        throw throwable;
                    }
                    tDocs.close();
                    {
                    }
                }
                Object var13_12 = null;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                QueryHitsQuery.this.hits.close();
                throw throwable;
            }
            QueryHitsQuery.this.hits.close();
            this.docs = sortedDocs.iterator();
        }

        public boolean next() throws IOException {
            if (this.docs.hasNext()) {
                this.currentDoc = (Integer)this.docs.next();
                return true;
            }
            return false;
        }

        public int doc() {
            return this.currentDoc;
        }

        public float score() throws IOException {
            return ((Float)this.scores.get(this.currentDoc)).floatValue();
        }

        public boolean skipTo(int target) throws IOException {
            do {
                if (this.next()) continue;
                return false;
            } while (target > this.doc());
            return true;
        }

        public Explanation explain(int doc) throws IOException {
            return new Explanation();
        }
    }

    public class QueryHitsQueryWeight
    extends Weight {
        private final Similarity similarity;

        public QueryHitsQueryWeight(Similarity similarity) {
            this.similarity = similarity;
        }

        public Query getQuery() {
            return QueryHitsQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new QueryHitsQueryScorer(reader, this.similarity);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

