/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jcr.PropertyType;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.ValueStorageFilterEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.ValueStorageNotFoundException;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.jcr.storage.value.ValuePluginFilter;
import org.exoplatform.services.jcr.storage.value.ValueStoragePlugin;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneStoragePluginProvider
extends ArrayList<ValueStoragePlugin>
implements ValueStoragePluginProvider {
    private static final long serialVersionUID = 4537116106932443262L;
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.StandaloneStoragePluginProvider");
    private static final String VALUE_STORAGE_ENABLED_PARAM = "enabled";
    private final ValueDataResourceHolder resorcesHolder = new ValueDataResourceHolder();

    public StandaloneStoragePluginProvider(WorkspaceEntry wsConfig, FileCleanerHolder holder) throws RepositoryConfigurationException, IOException {
        ArrayList<ValueStorageEntry> storages = wsConfig.getContainer().getValueStorages();
        if (storages != null) {
            for (ValueStorageEntry storageEntry : storages) {
                if (!storageEntry.getParameterBoolean(VALUE_STORAGE_ENABLED_PARAM, true).booleanValue()) continue;
                for (ValueStoragePlugin vsp : this) {
                    if (!vsp.getId().equals(storageEntry.getId())) continue;
                    throw new RepositoryConfigurationException("Value storage with ID '" + storageEntry.getId() + "' already exists");
                }
                Object o = null;
                try {
                    o = Class.forName(storageEntry.getType()).getConstructor(FileCleaner.class).newInstance(holder.getFileCleaner());
                }
                catch (InstantiationException e) {
                    log.error((Object)"Value Storage Plugin instantiation FAILED. ", (Throwable)e);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)"Value Storage Plugin instantiation FAILED. ", (Throwable)e);
                    continue;
                }
                catch (SecurityException e) {
                    log.error((Object)"Value Storage Plugin instantiation FAILED. ", (Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    log.error((Object)"Value Storage Plugin instantiation FAILED. ", (Throwable)e);
                    continue;
                }
                catch (InvocationTargetException e) {
                    log.error((Object)"Value Storage Plugin instantiation FAILED. ", (Throwable)e);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)"Value Storage Plugin instantiation FAILED. ", (Throwable)e);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"Value Storage Plugin instantiation FAILED. ", (Throwable)e);
                    continue;
                }
                if (!(o instanceof ValueStoragePlugin)) {
                    log.error((Object)("Not a ValueStoragePlugin object IGNORED: " + o));
                    continue;
                }
                ValueStoragePlugin plugin = o;
                ArrayList<ValuePluginFilter> filters = new ArrayList<ValuePluginFilter>();
                ArrayList<ValueStorageFilterEntry> filterEntries = storageEntry.getFilters();
                for (ValueStorageFilterEntry filterEntry : filterEntries) {
                    ValuePluginFilter filter = new ValuePluginFilter(PropertyType.valueFromName((String)filterEntry.getPropertyType()), null, null, filterEntry.getMinValueSize());
                    filters.add(filter);
                }
                Properties props = new Properties();
                List<SimpleParameterEntry> paramEntries = storageEntry.getParameters();
                for (SimpleParameterEntry paramEntry : paramEntries) {
                    props.setProperty(paramEntry.getName(), paramEntry.getValue());
                }
                plugin.init(props, this.resorcesHolder);
                plugin.setId(storageEntry.getId());
                plugin.setFilters(filters);
                this.add(plugin);
                log.info((Object)("Value Storage Plugin initialized " + plugin));
            }
        }
    }

    @Override
    public ValueIOChannel getApplicableChannel(PropertyData property, int valueOrderNumer) throws IOException {
        for (ValueStoragePlugin plugin : this) {
            List<ValuePluginFilter> filters = plugin.getFilters();
            for (ValuePluginFilter filter : filters) {
                if (!filter.match(property, valueOrderNumer)) continue;
                return plugin.openIOChannel();
            }
        }
        return null;
    }

    @Override
    public void checkConsistency(WorkspaceStorageConnection dataConnection) {
        for (ValueStoragePlugin plugin : this) {
            plugin.checkConsistency(dataConnection);
        }
    }

    @Override
    public ValueIOChannel getChannel(String storageId) throws IOException, ValueStorageNotFoundException {
        for (ValueStoragePlugin plugin : this) {
            if (!plugin.isSame(storageId)) continue;
            return plugin.openIOChannel();
        }
        throw new ValueStorageNotFoundException("No value storage found with id " + storageId);
    }
}

