/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.exporting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.xml.stream.XMLStreamException;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.NodeDataOrderComparator;
import org.exoplatform.services.jcr.impl.dataflow.PropertyDataOrderComparator;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.xml.sax.SAXException;

public abstract class BaseXmlExporter
extends ItemDataTraversingVisitor {
    public static final String DEFAULT_EMPTY_NAMESPACE_PREFIX = "jcr_default_empty_namespace_prefix";
    public static final String MULTI_VALUE_DELIMITER = " ";
    protected static final String JCR_ROOT = "jcr:root";
    private final NamespaceRegistry namespaceRegistry;
    private final boolean noRecurse;
    private final boolean skipBinary;
    private final String svNamespaceUri;
    private final ValueFactoryImpl systemValueFactory;

    public BaseXmlExporter(ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse, int maxLevel) throws RepositoryException {
        super(dataManager, maxLevel);
        this.skipBinary = skipBinary;
        this.noRecurse = noRecurse;
        this.namespaceRegistry = namespaceRegistry;
        this.svNamespaceUri = namespaceRegistry.getURI("sv");
        this.systemValueFactory = systemValueFactory;
    }

    public abstract void export(NodeData var1) throws RepositoryException, SAXException, XMLStreamException;

    public String getSvNamespaceUri() {
        return this.svNamespaceUri;
    }

    public boolean isNoRecurse() {
        return this.noRecurse;
    }

    public boolean isSkipBinary() {
        return this.skipBinary;
    }

    public void visit(NodeData node) throws RepositoryException {
        try {
            this.entering(node, this.currentLevel);
            if (this.maxLevel == -1 || this.currentLevel < this.maxLevel) {
                ++this.currentLevel;
                ArrayList<PropertyData> properies = new ArrayList<PropertyData>(this.dataManager.getChildPropertiesData(node));
                Collections.sort(properies, new PropertyDataOrderComparator());
                for (PropertyData data : properies) {
                    InternalQName propName = data.getQPath().getName();
                    if (Constants.JCR_LOCKISDEEP.equals((Object)propName) || Constants.JCR_LOCKOWNER.equals((Object)propName)) continue;
                    data.accept(this);
                }
                if (!this.isNoRecurse() && this.currentLevel > 0) {
                    ArrayList<NodeData> nodes = new ArrayList<NodeData>(this.dataManager.getChildNodesData(node));
                    Collections.sort(nodes, new NodeDataOrderComparator());
                    for (NodeData data : nodes) {
                        data.accept(this);
                    }
                }
                --this.currentLevel;
            }
            this.leaving(node, this.currentLevel);
        }
        catch (RepositoryException re) {
            this.currentLevel = 0;
            throw re;
        }
    }

    protected String getExportName(ItemData data, boolean encode) throws RepositoryException {
        String nodeName;
        QPath itemPath = data.getQPath();
        if (Constants.ROOT_PATH.equals(itemPath)) {
            nodeName = JCR_ROOT;
        } else {
            String prefix;
            InternalQName internalNodeName = itemPath.getName();
            if (encode) {
                internalNodeName = ISO9075.encode(itemPath.getName());
            }
            nodeName = (prefix = this.namespaceRegistry.getPrefix(internalNodeName.getNamespace())).length() == 0 ? "" : prefix + ":";
            nodeName = "".equals(itemPath.getName().getName()) && itemPath.isDescendantOf(Constants.EXO_NAMESPACES_PATH) ? nodeName + DEFAULT_EMPTY_NAMESPACE_PREFIX : nodeName + internalNodeName.getName();
        }
        return nodeName;
    }

    protected String getValueAsStringForExport(ValueData data, int type) throws IOException, RepositoryException {
        String charValue = null;
        switch (type) {
            case 2: {
                if (this.skipBinary) {
                    charValue = "";
                    break;
                }
                charValue = Base64.encode((byte[])data.getAsByteArray(), (int)0, (int)((int)data.getLength()), (int)0, (String)"");
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                try {
                    charValue = this.systemValueFactory.loadValue(data, type).getString();
                    break;
                }
                catch (ValueFormatException e) {
                    throw new RepositoryException((Throwable)e);
                }
                catch (UnsupportedRepositoryOperationException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            default: {
                charValue = ValueDataConvertor.readString(data);
            }
        }
        return charValue;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public ValueFactoryImpl getSystemValueFactory() {
        return this.systemValueFactory;
    }
}

