/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.exporting;

import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.xml.exporting.BaseXmlExporter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class HandlingContentExporter
extends BaseXmlExporter {
    protected final ContentHandler contentHandler;

    public HandlingContentExporter(ContentHandler handler, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        super(dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse, noRecurse ? 1 : -1);
        this.contentHandler = handler;
    }

    public void export(NodeData node) throws RepositoryException, SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
            this.startPrefixMapping();
            node.accept(this);
            this.endPrefixMapping();
            this.contentHandler.endDocument();
        }
    }

    protected void endPrefixMapping() throws RepositoryException, SAXException {
        String[] prefixes;
        for (String prefix : prefixes = this.getNamespaceRegistry().getPrefixes()) {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    protected void startPrefixMapping() throws RepositoryException, SAXException {
        String[] prefixes;
        for (String prefix : prefixes = this.getNamespaceRegistry().getPrefixes()) {
            if (prefix == null || prefix.length() < 1 || prefix.equals("xml")) continue;
            this.contentHandler.startPrefixMapping(prefix, this.getNamespaceRegistry().getURI(prefix));
        }
    }
}

