/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.DigesterFactory;
import org.apache.catalina.startup.TldRuleSet;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.xml.sax.InputSource;

public final class TldConfig
implements LifecycleListener {
    private static HashSet<String> noTldJars;
    private static Log log;
    private Context context = null;
    private static final StringManager sm;
    private static Digester tldDigester;
    private static boolean tldValidation;
    private static boolean tldNamespaceAware;
    private boolean rescan = true;
    private ArrayList<String> listeners = new ArrayList();

    public static void setNoTldJars(String jarNames) {
        if (jarNames != null) {
            noTldJars.clear();
            StringTokenizer tokenizer = new StringTokenizer(jarNames, ",");
            while (tokenizer.hasMoreElements()) {
                noTldJars.add(tokenizer.nextToken());
            }
        }
    }

    public void setTldValidation(boolean tldValidation) {
        TldConfig.tldValidation = tldValidation;
    }

    public boolean getTldValidation() {
        return tldValidation;
    }

    public boolean getTldNamespaceAware() {
        return tldNamespaceAware;
    }

    public void setTldNamespaceAware(boolean tldNamespaceAware) {
        TldConfig.tldNamespaceAware = tldNamespaceAware;
    }

    public boolean isRescan() {
        return this.rescan;
    }

    public void setRescan(boolean rescan) {
        this.rescan = rescan;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void addApplicationListener(String s) {
        log.debug((Object)("Add tld listener " + s));
        this.listeners.add(s);
    }

    public String[] getTldListeners() {
        String[] result = new String[this.listeners.size()];
        this.listeners.toArray(result);
        return result;
    }

    public void execute() throws Exception {
        long t1 = System.currentTimeMillis();
        Set resourcePaths = this.tldScanResourcePaths();
        Map jarPaths = this.getJarPaths();
        for (String path : resourcePaths) {
            if (path.endsWith(".jar")) {
                this.tldScanJar(path);
                continue;
            }
            this.tldScanTld(path);
        }
        if (jarPaths != null) {
            Iterator<Object> paths = jarPaths.values().iterator();
            while (paths.hasNext()) {
                this.tldScanJar((File)paths.next());
            }
        }
        String[] list = this.getTldListeners();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding tld listeners:" + list.length));
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            this.context.addApplicationListener(list[i]);
        }
        long t2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setTldScanTime(t2 - t1);
        }
    }

    private void tldScanJar(String resourcePath) throws Exception {
        URL url;
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Scanning JAR at resource path '" + resourcePath + "'"));
        }
        if ((url = this.context.getServletContext().getResource(resourcePath)) == null) {
            throw new IllegalArgumentException(sm.getString("contextConfig.tldResourcePath", resourcePath));
        }
        File file = null;
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(url.getFile());
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.tldScanJar(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tldScanJar(File file) throws Exception {
        JarFile jarFile = null;
        String name = null;
        String jarPath = file.getAbsolutePath();
        jarFile = new JarFile(file);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            name = entry.getName();
            if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("  Processing TLD at '" + name + "'"));
            }
            try {
                this.tldScanStream(new InputSource(jarFile.getInputStream(entry)));
            }
            catch (Exception e) {
                log.error((Object)sm.getString("contextConfig.tldEntryException", name, jarPath, this.context.getPath()), (Throwable)e);
            }
        }
        Object var9_9 = null;
        if (jarFile == null) return;
        try {
            jarFile.close();
            return;
        }
        catch (Throwable t) {}
        return;
        {
            catch (Exception e) {
                log.error((Object)sm.getString("contextConfig.tldJarException", jarPath, this.context.getPath()), (Throwable)e);
                Object var9_10 = null;
                if (jarFile == null) return;
                try {
                    jarFile.close();
                    return;
                }
                catch (Throwable t) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanStream(InputSource resourceStream) throws Exception {
        Digester digester = tldDigester;
        synchronized (digester) {
            try {
                tldDigester.push((Object)this);
                tldDigester.parse(resourceStream);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                tldDigester.reset();
                throw throwable;
            }
            tldDigester.reset();
        }
    }

    private void tldScanTld(String resourcePath) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Scanning TLD at resource path '" + resourcePath + "'"));
        }
        InputSource inputSource = null;
        try {
            InputStream stream = this.context.getServletContext().getResourceAsStream(resourcePath);
            if (stream == null) {
                throw new IllegalArgumentException(sm.getString("contextConfig.tldResourcePath", resourcePath));
            }
            inputSource = new InputSource(stream);
            if (inputSource == null) {
                throw new IllegalArgumentException(sm.getString("contextConfig.tldResourcePath", resourcePath));
            }
            this.tldScanStream(inputSource);
        }
        catch (Exception e) {
            throw new ServletException(sm.getString("contextConfig.tldFileException", resourcePath, this.context.getPath()), (Throwable)e);
        }
    }

    private Set tldScanResourcePaths() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)" Accumulating TLD resource paths");
        }
        HashSet<String> resourcePaths = new HashSet<String>();
        if (log.isTraceEnabled()) {
            log.trace((Object)"  Scanning <taglib> elements in web.xml");
        }
        String[] taglibs = this.context.findTaglibs();
        for (int i = 0; i < taglibs.length; ++i) {
            String resourcePath = this.context.findTaglib(taglibs[i]);
            if (!resourcePath.startsWith("/")) {
                resourcePath = "/WEB-INF/" + resourcePath;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("   Adding path '" + resourcePath + "' for URI '" + taglibs[i] + "'"));
            }
            resourcePaths.add(resourcePath);
        }
        DirContext resources = this.context.getResources();
        if (resources != null) {
            this.tldScanResourcePathsWebInf(resources, "/WEB-INF", resourcePaths);
        }
        return resourcePaths;
    }

    private void tldScanResourcePathsWebInf(DirContext resources, String rootPath, Set tldPaths) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("  Scanning TLDs in " + rootPath + " subdirectory"));
        }
        try {
            NamingEnumeration<NameClassPair> items = resources.list(rootPath);
            while (items.hasMoreElements()) {
                NameClassPair item = (NameClassPair)items.nextElement();
                String resourcePath = rootPath + "/" + item.getName();
                if (!resourcePath.endsWith(".tld") && (resourcePath.startsWith("/WEB-INF/classes") || resourcePath.startsWith("/WEB-INF/lib"))) continue;
                if (resourcePath.endsWith(".tld")) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("   Adding path '" + resourcePath + "'"));
                    }
                    tldPaths.add(resourcePath);
                    continue;
                }
                this.tldScanResourcePathsWebInf(resources, resourcePath, tldPaths);
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
    }

    private Map getJarPaths() {
        ClassLoader webappLoader;
        HashMap<String, File> jarPathMap = null;
        for (ClassLoader loader = webappLoader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)loader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                String path;
                if (!"file".equals(urls[i].getProtocol())) continue;
                File file = null;
                try {
                    file = new File(urls[i].toURI());
                }
                catch (URISyntaxException e) {
                    file = new File(urls[i].getFile());
                }
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!file.exists() || !(path = file.getAbsolutePath()).endsWith(".jar") || loader != webappLoader && noTldJars != null && noTldJars.contains(file.getName())) continue;
                if (jarPathMap == null) {
                    jarPathMap = new HashMap<String, File>();
                    jarPathMap.put(path, file);
                    continue;
                }
                if (jarPathMap.containsKey(path)) continue;
                jarPathMap.put(path, file);
            }
        }
        return jarPathMap;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.context = (Context)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("tldConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("init")) {
            this.init();
        } else if (event.getType().equals("start")) {
            try {
                this.execute();
            }
            catch (Exception e) {
                log.error((Object)sm.getString("tldConfig.execute", this.context.getPath()), (Throwable)e);
            }
        } else if (event.getType().equals("stop")) {
            this.listeners.clear();
        }
    }

    private void init() {
        if (tldDigester == null) {
            this.setTldValidation(this.context.getTldValidation());
            this.setTldNamespaceAware(this.context.getTldNamespaceAware());
            if (!tldValidation) {
                this.setTldValidation(((StandardHost)this.context.getParent()).getXmlValidation());
            }
            if (!tldNamespaceAware) {
                this.setTldNamespaceAware(((StandardHost)this.context.getParent()).getXmlNamespaceAware());
            }
            tldDigester = DigesterFactory.newDigester(tldValidation, tldNamespaceAware, (RuleSet)new TldRuleSet());
            tldDigester.getParser();
        }
    }

    static {
        log = LogFactory.getLog(TldConfig.class);
        noTldJars = new HashSet();
        noTldJars.add("bootstrap.jar");
        noTldJars.add("commons-daemon.jar");
        noTldJars.add("tomcat-juli.jar");
        noTldJars.add("annotations-api.jar");
        noTldJars.add("catalina.jar");
        noTldJars.add("catalina-ant.jar");
        noTldJars.add("catalina-ha.jar");
        noTldJars.add("catalina-tribes.jar");
        noTldJars.add("el-api.jar");
        noTldJars.add("jasper.jar");
        noTldJars.add("jasper-el.jar");
        noTldJars.add("ecj-3.3.1.jar");
        noTldJars.add("jsp-api.jar");
        noTldJars.add("servlet-api.jar");
        noTldJars.add("tomcat-coyote.jar");
        noTldJars.add("tomcat-dbcp.jar");
        noTldJars.add("tomcat-i18n-en.jar");
        noTldJars.add("tomcat-i18n-es.jar");
        noTldJars.add("tomcat-i18n-fr.jar");
        noTldJars.add("tomcat-i18n-ja.jar");
        noTldJars.add("ant.jar");
        noTldJars.add("commons-dbcp.jar");
        noTldJars.add("commons-beanutils.jar");
        noTldJars.add("commons-fileupload-1.0.jar");
        noTldJars.add("commons-pool.jar");
        noTldJars.add("commons-digester.jar");
        noTldJars.add("commons-logging.jar");
        noTldJars.add("commons-collections.jar");
        noTldJars.add("jmx.jar");
        noTldJars.add("jmx-tools.jar");
        noTldJars.add("xercesImpl.jar");
        noTldJars.add("xmlParserAPIs.jar");
        noTldJars.add("xml-apis.jar");
        noTldJars.add("sunjce_provider.jar");
        noTldJars.add("ldapsec.jar");
        noTldJars.add("localedata.jar");
        noTldJars.add("dnsns.jar");
        noTldJars.add("tools.jar");
        noTldJars.add("sunpkcs11.jar");
        sm = StringManager.getManager("org.apache.catalina.startup");
        tldDigester = null;
        tldValidation = false;
        tldNamespaceAware = false;
    }
}

