/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.IOException;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class CreateLandscapePDF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String message, String outfile) throws IOException, COSVisitorException {
        PDDocument doc = null;
        try {
            doc = new PDDocument();
            PDType1Font font = PDType1Font.HELVETICA;
            PDPage page = new PDPage();
            page.setMediaBox(PDPage.PAGE_SIZE_A4);
            page.setRotation(90);
            doc.addPage(page);
            PDRectangle pageSize = page.findMediaBox();
            float pageWidth = pageSize.getWidth();
            float fontSize = 12.0f;
            float stringWidth = font.getStringWidth(message) * fontSize / 1000.0f;
            float startX = 100.0f;
            float startY = 100.0f;
            PDPageContentStream contentStream = new PDPageContentStream(doc, page, false, false);
            contentStream.concatenate2CTM(0.0, 1.0, -1.0, 0.0, pageWidth, 0.0);
            contentStream.setFont(font, fontSize);
            contentStream.beginText();
            contentStream.moveTextPositionByAmount(startX, startY);
            contentStream.drawString(message);
            contentStream.moveTextPositionByAmount(0.0f, 100.0f);
            contentStream.drawString(message);
            contentStream.moveTextPositionByAmount(100.0f, 100.0f);
            contentStream.drawString(message);
            contentStream.endText();
            contentStream.drawLine(startX - 2.0f, startY - 2.0f, startX - 2.0f, startY + 200.0f + fontSize);
            contentStream.drawLine(startX - 2.0f, startY + 200.0f + fontSize, startX + 100.0f + stringWidth + 2.0f, startY + 200.0f + fontSize);
            contentStream.drawLine(startX + 100.0f + stringWidth + 2.0f, startY + 200.0f + fontSize, startX + 100.0f + stringWidth + 2.0f, startY - 2.0f);
            contentStream.drawLine(startX + 100.0f + stringWidth + 2.0f, startY - 2.0f, startX - 2.0f, startY - 2.0f);
            contentStream.close();
            doc.save(outfile);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) {
        CreateLandscapePDF app = new CreateLandscapePDF();
        try {
            if (args.length != 2) {
                app.usage();
            } else {
                app.doIt(args[0], args[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <Message> <output-file>");
    }
}

