/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class FilePersistedValueData
extends AbstractPersistedValueData
implements Externalizable {
    private static final long serialVersionUID = -8183328056670315388L;
    protected File file;
    protected FileChannel channel;

    public FilePersistedValueData() {
    }

    public FilePersistedValueData(int orderNumber, File file) {
        super(orderNumber);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getAsStream() throws IOException {
        return PrivilegedFileHelper.fileInputStream((File)this.file);
    }

    public byte[] getAsByteArray() throws IllegalStateException, IOException {
        return this.fileToByteArray();
    }

    public long getLength() {
        return PrivilegedFileHelper.length((File)this.file);
    }

    public long read(OutputStream stream, long length, long position) throws IOException {
        if (this.channel == null) {
            this.channel = PrivilegedFileHelper.fileInputStream((File)this.file).getChannel();
        }
        if (position >= this.channel.size() && position > 0L) {
            throw new IOException("Position " + position + " out of value size " + this.channel.size());
        }
        if (position + length >= this.channel.size()) {
            length = this.channel.size() - position;
        }
        MappedByteBuffer bb = this.channel.map(FileChannel.MapMode.READ_ONLY, position, length);
        WritableByteChannel ch = stream instanceof FileOutputStream ? ((FileOutputStream)stream).getChannel() : Channels.newChannel(stream);
        ch.write(bb);
        ch.close();
        return length;
    }

    public boolean isByteArray() {
        return false;
    }

    public boolean equals(ValueData another) {
        if (this == another) {
            return true;
        }
        if (!this.isByteArray() && !another.isByteArray()) {
            if (another instanceof TransientValueData) {
                return this.file.equals(((TransientValueData)another).getSpoolFile());
            }
            if (another instanceof FilePersistedValueData) {
                return this.file.equals(((FilePersistedValueData)another).getFile());
            }
        }
        return false;
    }

    public TransientValueData createTransientCopy() throws RepositoryException {
        return new TransientValueData(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fileToByteArray() throws IOException {
        ByteBuffer bb;
        FileChannel fch;
        block3: {
            byte[] byArray;
            fch = PrivilegedFileHelper.fileInputStream((File)this.file).getChannel();
            try {
                bb = ByteBuffer.allocate((int)fch.size());
                fch.read(bb);
                if (!bb.hasArray()) break block3;
                byArray = bb.array();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                fch.close();
                throw throwable;
            }
            fch.close();
            return byArray;
        }
        byte[] tmpb = new byte[bb.capacity()];
        bb.get(tmpb);
        byte[] byArray = tmpb;
        Object var6_6 = null;
        fch.close();
        return byArray;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.orderNumber = in.readInt();
        int size = in.readInt();
        if (size >= 0) {
            byte[] buf = new byte[size];
            in.readFully(buf);
            File f = new File(new String(buf, "UTF-8"));
            this.file = PrivilegedFileHelper.exists((File)f) ? f : null;
        } else {
            throw new IOException("readExternal: Persisted ValueData with null file found");
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.orderNumber);
        if (this.file == null) {
            throw new IOException("writeExternal: Persisted ValueData with null file found");
        }
        byte[] buf = PrivilegedFileHelper.getCanonicalPath((File)this.file).getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
    }
}

