/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.util;

import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.services.jcr.util.StringNumberParser;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ConfigurationFormat {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ConfigurationFormat");

    public static boolean parseBoolean(String text) {
        try {
            text = Deserializer.resolveNClean((String)text);
            return Boolean.valueOf(text);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Unparseable boolean '" + text + "'."), e);
            return false;
        }
    }

    public static int parseInt(String text) {
        try {
            text = Deserializer.resolveNClean((String)text);
            return StringNumberParser.parseInt(text);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Unparseable int '" + text + "'. Check StringNumberParser.parseInt for details."), e);
            return 0;
        }
    }

    public static long parseLong(String text) {
        try {
            text = Deserializer.resolveNClean((String)text);
            return StringNumberParser.parseLong(text);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Unparseable long '" + text + "'. Check StringNumberParser.parseLong for details."), e);
            return 0L;
        }
    }

    public static long parseTime(String text) {
        try {
            text = Deserializer.resolveNClean((String)text);
            return StringNumberParser.parseTime(text);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Unparseable time (as long) '" + text + "'. Check StringNumberParser.parseTime for details."), e);
            return 0L;
        }
    }

    public static String serializeTime(long time) {
        try {
            return StringNumberParser.serializeTime(time);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Unserialable time '" + time + "'. Check StringNumberParser.serializeTime for details."), e);
            return "";
        }
    }

    public static String serializeInt(int integerValue) {
        try {
            return StringNumberParser.serializeInt(integerValue);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Unserialable integer value '" + integerValue + "'. Check StringNumberParser.serializeInt for details."), e);
            return "";
        }
    }

    public static String serializeLong(long longValue) {
        try {
            return StringNumberParser.serializeLong(longValue);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Unserialable long value '" + longValue + "'. Check StringNumberParser.serializeLong for details."), e);
            return "";
        }
    }
}

