/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions;

import java.io.UnsupportedEncodingException;
import javax.el.ELException;
import org.apache.commons.codec.binary.Base64;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.expressions.Functions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class OpensocialFunctions {
    private OpensocialFunctions() {
    }

    @Functions.Expose(prefix="osx", names={"parseJson"})
    public static Object parseJson(String text) {
        if (text == null || "".equals(text)) {
            return null;
        }
        try {
            if (text.startsWith("[")) {
                return new JSONArray(text);
            }
            return new JSONObject(text);
        }
        catch (JSONException je) {
            throw new ELException((Throwable)je);
        }
    }

    @Functions.Expose(prefix="osx", names={"decodeBase64"})
    public static String decodeBase64(String text) {
        if (text == null) {
            return null;
        }
        try {
            return new String(Base64.decodeBase64((byte[])text.getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    @Functions.Expose(prefix="osx", names={"urlEncode"})
    public static String formEncode(String text) {
        if (text == null) {
            return null;
        }
        return Utf8UrlCoder.encode(text);
    }

    @Functions.Expose(prefix="osx", names={"urlDecode"})
    public static String formDecode(String text) {
        if (text == null) {
            return null;
        }
        return Utf8UrlCoder.decode(text);
    }
}

