/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.CyclicBarrier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.VIEW_SYNC;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;

public class ConnectStressTest
extends TestCase {
    static final int NUM = 20;
    private final CyclicBarrier barrier = new CyclicBarrier(21);
    private final MyThread[] threads = new MyThread[20];
    static final String groupname = "ConcurrentTestDemo";
    static final String props = "udp.xml";

    public ConnectStressTest(String name) {
        super(name);
    }

    static void log(String msg) {
        System.out.println("-- [" + Thread.currentThread().getName() + "] " + msg);
    }

    public void testConcurrentJoinsAndLeaves() throws Exception {
        int i;
        for (int i2 = 0; i2 < this.threads.length; ++i2) {
            this.threads[i2] = new MyThread(i2, this.barrier);
            this.threads[i2].start();
        }
        this.barrier.await();
        int min = 20;
        int max = 0;
        for (i = 0; i < 20; ++i) {
            for (MyThread thread : this.threads) {
                JChannel ch = thread.getChannel();
                View view = ch.getView();
                if (view == null) continue;
                int size = view.size();
                min = Math.min(size, 20);
                max = Math.max(size, max);
            }
            if (min >= 20 && max >= 20) break;
            System.out.println("min=" + min + ", max=" + max);
            Util.sleep(2000L);
        }
        System.out.println("reached 20 members: min=" + min + ", max=" + max);
        assert (min >= 20 && max >= 20) : "min=" + min + ", max=" + max + ", expected: " + 20;
        System.out.println("Starting the disconnect phase");
        for (i = 0; i < this.threads.length; ++i) {
            MyThread thread = this.threads[i];
            System.out.print("disconnecting " + thread.getName());
            thread.disconnect();
            System.out.println(" OK");
        }
    }

    private static void changeProperties(JChannel ch) {
        NAKACK nakack;
        VIEW_SYNC sync;
        MERGE2 merge;
        ch.setOpt(5, true);
        ProtocolStack stack = ch.getProtocolStack();
        GMS gms = (GMS)stack.findProtocol("GMS");
        if (gms != null) {
            gms.setViewBundling(true);
            gms.setMaxBundlingTime(300L);
            gms.setPrintLocalAddr(false);
        }
        if ((merge = (MERGE2)stack.findProtocol("MERGE2")) != null) {
            merge.setMinInterval(2000L);
            merge.setMaxInterval(5000L);
        }
        if ((sync = (VIEW_SYNC)stack.findProtocol(VIEW_SYNC.class)) != null) {
            sync.setAverageSendInterval(5000L);
        }
        if ((nakack = (NAKACK)stack.findProtocol(NAKACK.class)) != null) {
            nakack.setLogDiscardMsgs(false);
        }
    }

    public static Test suite() {
        TestSuite s = new TestSuite();
        s.addTest((Test)new ConnectStressTest("testConcurrentJoinsAndLeaves"));
        return s;
    }

    public static class MyThread
    extends Thread {
        private final CyclicBarrier barrier;
        private JChannel ch = null;

        public MyThread(int i, CyclicBarrier barrier) {
            super("thread #" + i);
            this.barrier = barrier;
        }

        public void disconnect() {
            this.ch.disconnect();
        }

        public void close() {
            Util.close((Channel)this.ch);
        }

        public JChannel getChannel() {
            return this.ch;
        }

        @Override
        public void run() {
            try {
                this.ch = new JChannel(ConnectStressTest.props);
                ConnectStressTest.changeProperties(this.ch);
                this.barrier.await();
                this.ch.connect(ConnectStressTest.groupname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

