/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.util.Scheduler;
import org.jgroups.util.SchedulerListener;
import org.jgroups.util.Util;

public class SchedulerTest
extends TestCase {
    public SchedulerTest(String name) {
        super(name);
    }

    public void testScheduler() throws Exception {
        Scheduler sch = new Scheduler();
        sch.setListener(new Listener());
        sch.add(new MyThread("Bela"));
        sch.add(new MyThread("Janet"));
        sch.add(new MyThread("Ralph"));
        sch.start();
        sch.add(new MyThread("Frank"));
        sch.add(new MyThread("Marco"));
        Util.sleep(1000L);
        sch.addPrio(new MyThread("Gabi"));
        sch.add(new MyThread("Rolf"));
        sch.addPrio(new MyThread("Gabi2"));
        sch.addPrio(new MyThread("Gabi3"));
        sch.addPrio(new MyThread("Gabi4"));
        Util.sleep(1000L);
        sch.stop();
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{SchedulerTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    static class Listener
    implements SchedulerListener {
        Listener() {
        }

        @Override
        public void started(Runnable t) {
            System.out.println("--> Started: " + t);
        }

        @Override
        public void stopped(Runnable t) {
            System.out.println("--> Stopped: " + t);
        }

        @Override
        public void suspended(Runnable t) {
            System.out.println("--> Suspended: " + t);
        }

        @Override
        public void resumed(Runnable t) {
            System.out.println("--> Resumed: " + t);
        }
    }

    static class MyThread
    implements Runnable {
        String name;

        MyThread(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            long sleep_time = (long)(Math.random() * 1000.0);
            System.out.println("\n--> " + this.name + ": sleeping for " + sleep_time + " ms");
            Util.sleep(sleep_time);
            System.out.println("--> " + this.name + ": Done");
        }

        public String toString() {
            return "MyThread [name=" + this.name + ']';
        }
    }
}

