/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.Util;

public class SequencerFailoverTest
extends TestCase {
    JChannel ch1;
    JChannel ch2;
    JChannel ch3;
    static final String GROUP = "demo-group";
    static final int NUM_MSGS = 50;
    String props = "sequencer.xml";

    public SequencerFailoverTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.ch1 = new JChannel(this.props);
        this.ch1.connect(GROUP);
        this.ch2 = new JChannel(this.props);
        this.ch2.connect(GROUP);
        this.ch3 = new JChannel(this.props);
        this.ch3.connect(GROUP);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.ch3 != null) {
            this.ch3.close();
            this.ch3 = null;
        }
        if (this.ch2 != null) {
            this.ch2.close();
            this.ch2 = null;
        }
    }

    public void testBroadcastSequence() throws Exception {
        MyReceiver r2 = new MyReceiver();
        MyReceiver r3 = new MyReceiver();
        this.ch2.setReceiver(r2);
        this.ch3.setReceiver(r3);
        new Thread(){

            @Override
            public void run() {
                Util.sleep(3000L);
                System.out.println("** killing ch1");
                SequencerFailoverTest.this.ch1.shutdown();
                SequencerFailoverTest.this.ch1 = null;
                System.out.println("** ch1 killed");
            }
        }.start();
        for (int i = 1; i <= 50; ++i) {
            Util.sleep(300L);
            this.ch2.send(new Message(null, null, new Integer(i)));
            System.out.print("-- messages sent: " + i + "/" + 50 + "\r");
        }
        System.out.println("");
        View v2 = this.ch2.getView();
        View v3 = this.ch3.getView();
        System.out.println("ch2's view: " + v2 + "\nch3's view: " + v3);
        SequencerFailoverTest.assertEquals((Object)v2, (Object)v3);
        SequencerFailoverTest.assertEquals((int)2, (int)v2.size());
        for (int i = 15000; i > 0; i -= 1000) {
            int s2 = r2.size();
            int s3 = r3.size();
            if (s2 >= 50 && s3 >= 50) {
                System.out.print("ch2: " + s2 + " msgs, ch3: " + s3 + " msgs\r");
                break;
            }
            Util.sleep(1000L);
            System.out.print("sleeping for " + i / 1000 + " seconds (ch2: " + s2 + " msgs, ch3: " + s3 + " msgs)\r");
        }
        System.out.println("-- verifying messages on ch2 and ch3");
        List<Integer> list2 = r2.getList();
        List<Integer> list3 = r3.getList();
        SequencerFailoverTest.assertEquals((int)list2.size(), (int)list3.size());
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{SequencerFailoverTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        List<Integer> list = new LinkedList<Integer>();

        private MyReceiver() {
        }

        public List<Integer> getList() {
            return this.list;
        }

        public int size() {
            return this.list.size();
        }

        @Override
        public void receive(Message msg) {
            this.list.add((Integer)msg.getObject());
        }

        void clear() {
            this.list.clear();
        }
    }
}

