/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.ancillary.opt.ConstLocalOptimization;
import com.google.caja.ancillary.opt.Fact;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Conditional;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.NullLiteral;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.OperatorCategory;
import com.google.caja.parser.js.RealLiteral;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParseTreeKB {
    private final Map<String, Pair<Expression, Fact>> facts = Maps.newHashMap();
    private boolean needsInference;
    private int longestKeyLength = 0;
    private static final FilePosition UNK = FilePosition.UNKNOWN;
    private static final EnumMap<Operator, Operator> WITH_REVERSE_ORDER = new EnumMap(Operator.class);
    private static Map<Class<?>, String> CLASS_NAME_DIGEST_IDX;

    public ParseTreeKB() {
        this.addFactInt(new Reference(new Identifier(UNK, "undefined")), Fact.UNDEFINED);
        this.addFactInt(new Reference(new Identifier(UNK, "this")), Fact.GLOBAL);
    }

    public Fact getFact(Expression e) {
        return this.getFact(this.optNodeDigest(e));
    }

    private Fact getFact(String digest) {
        Pair<Expression, Fact> fact = this.facts.get(digest);
        return fact != null ? (Fact)fact.b : null;
    }

    public Block optimize(Block js, MessageQueue mq) {
        this.finishInference();
        while (true) {
            Result out = new Result();
            Scope s = Scope.fromProgram(js, mq);
            this.optimize(s, js, false, false, false, false, out);
            Block optimized = ConstLocalOptimization.optimize((Block)out.node);
            if (optimized == js) {
                return optimized;
            }
            js = optimized;
        }
    }

    public void addFact(Expression e, Fact fact) {
        this.addFactInt(ParseTreeKB.rfold(e, false), fact);
    }

    private void addFactInt(Expression e, Fact fact) {
        String digest;
        Pair<Expression, Fact> oldFact;
        if (fact.type == Fact.Type.LIKE && "boolean".equals(e.typeOf())) {
            Fact fact2 = fact = fact.isTruthy() ? Fact.TRUE : Fact.FALSE;
        }
        if ((oldFact = this.facts.get(digest = ParseTreeKB.nodeDigest(e))) != null && !((Fact)oldFact.b).isLessSpecificThan(fact)) {
            return;
        }
        this.putFact(e, digest, fact);
        if (e instanceof Operation) {
            Operator swapped;
            Operation op = (Operation)e;
            List<? extends Expression> operands = op.children();
            switch (op.getOperator()) {
                case NOT: {
                    this.addFuzzyFact(operands.get(0), !fact.isTruthy());
                    break;
                }
                case LESS_THAN: 
                case GREATER_THAN: {
                    if (!fact.isTruthy()) break;
                    Expression left = operands.get(0);
                    Expression right = operands.get(1);
                    Operator included = op.getOperator() == Operator.LESS_THAN ? Operator.LESS_EQUALS : Operator.GREATER_EQUALS;
                    this.addFactInt(Operation.create(UNK, included, left, right), Fact.TRUE);
                    this.addFactInt(Operation.create(UNK, Operator.STRICTLY_NOT_EQUAL, left, right), Fact.TRUE);
                    break;
                }
                case LESS_EQUALS: 
                case GREATER_EQUALS: {
                    if (!fact.isFalsey()) break;
                    Expression left = operands.get(0);
                    Expression right = operands.get(1);
                    this.addFactInt(Operation.create(UNK, Operator.STRICTLY_NOT_EQUAL, left, right), Fact.TRUE);
                    break;
                }
                case INSTANCE_OF: {
                    this.addFactInt(Operation.create(UNK, Operator.TYPEOF, operands.get(1)), Fact.is(StringLiteral.valueOf(UNK, "function")));
                    if (!fact.isTruthy()) break;
                    this.addFactInt(operands.get(0), Fact.TRUTHY);
                    break;
                }
                case EQUAL: {
                    this.addFactInt(Operation.create(UNK, Operator.NOT_EQUAL, operands.get(0), operands.get(1)), fact.isTruthy() ? Fact.FALSE : Fact.TRUE);
                    break;
                }
                case NOT_EQUAL: {
                    this.addFactInt(Operation.create(UNK, Operator.EQUAL, operands.get(0), operands.get(1)), fact.isTruthy() ? Fact.FALSE : Fact.TRUE);
                    break;
                }
                case STRICTLY_EQUAL: {
                    Expression lhs;
                    if (fact.isTruthy()) {
                        lhs = operands.get(0);
                        Expression rhs = operands.get(1);
                        this.addFactInt(Operation.create(UNK, Operator.EQUAL, lhs, rhs), Fact.TRUE);
                        if (rhs instanceof Literal) {
                            this.addFactInt(lhs, Fact.is((Literal)rhs));
                        } else if (ParseTreeKB.isThis(rhs) && lhs instanceof Reference) {
                            this.addFactInt(lhs, Fact.GLOBAL);
                        } else {
                            Boolean truthiness;
                            String typeOf = rhs.typeOf();
                            if (typeOf != null && lhs.typeOf() == null) {
                                this.addFactInt(Operation.create(UNK, Operator.TYPEOF, lhs), Fact.is(StringLiteral.valueOf(UNK, typeOf)));
                            }
                            if ((truthiness = rhs.conditionResult()) != null) {
                                this.addFuzzyFact(lhs, truthiness);
                            }
                        }
                    } else {
                        Expression rhs;
                        lhs = operands.get(0);
                        if (ParseTreeNodes.deepEquals(lhs, rhs = operands.get(1))) {
                            this.addFactInt(lhs, Fact.is(new RealLiteral(UNK, Double.NaN)));
                        }
                    }
                    this.addFactInt(Operation.create(UNK, Operator.STRICTLY_NOT_EQUAL, operands.get(0), operands.get(1)), fact.isTruthy() ? Fact.FALSE : Fact.TRUE);
                    break;
                }
                case STRICTLY_NOT_EQUAL: {
                    this.addFactInt(Operation.create(UNK, Operator.STRICTLY_EQUAL, operands.get(0), operands.get(1)), fact.isTruthy() ? Fact.FALSE : Fact.TRUE);
                    break;
                }
                case LOGICAL_AND: 
                case LOGICAL_OR: {
                    boolean isAnd;
                    boolean bl = isAnd = op.getOperator() == Operator.LOGICAL_AND;
                    if (fact.isTruthy() != isAnd) break;
                    this.addFuzzyFact(operands.get(0), isAnd);
                    this.addFactInt(operands.get(1), fact);
                    break;
                }
                case MEMBER_ACCESS: 
                case SQUARE_BRACKET: {
                    if (!fact.isTruthy()) break;
                    this.addFuzzyFact(operands.get(0), true);
                    break;
                }
                case TYPEOF: {
                    if (fact.type != Fact.Type.IS || !(fact.value instanceof StringLiteral)) break;
                    String s = ((StringLiteral)fact.value).getUnquotedValue();
                    Expression op0 = operands.get(0);
                    if ("undefined".equals(s)) {
                        this.addFactInt(op0, Fact.UNDEFINED);
                        break;
                    }
                    if ("function".equals(s)) {
                        this.addFactInt(op0, Fact.TRUTHY);
                    }
                    this.addFactInt(Operation.create(UNK, Operator.STRICTLY_EQUAL, op0, Fact.UNDEFINED.value), Fact.FALSE);
                    break;
                }
            }
            if (operands.size() == 2 && (swapped = WITH_REVERSE_ORDER.get((Object)op.getOperator())) != null) {
                this.addFactInt(Operation.create(op.getFilePosition(), swapped, operands.get(1), operands.get(0)), fact);
            }
        }
    }

    void finishInference() {
        if (!this.needsInference) {
            return;
        }
        Set<String> globals = Sets.newHashSet();
        globals.add("this");
        List<Pair<Expression, Fact>> factList = Lists.newArrayList(this.facts.values());
        for (Pair<Expression, Fact> fe : factList) {
            if (fe.b != Fact.GLOBAL) continue;
            globals.add(((Reference)fe.a).getIdentifierName());
        }
        if (!globals.isEmpty()) {
            for (Pair<Expression, Fact> fe : factList) {
                String topRef;
                if (fe.b == Fact.GLOBAL) continue;
                Expression e = (Expression)fe.a;
                Operator op = null;
                if (Operation.is((ParseTreeNode)e, Operator.TYPEOF)) {
                    op = Operator.TYPEOF;
                    e = (Expression)e.children().get(0);
                }
                if ((topRef = ParseTreeKB.topRef(e)) == null) continue;
                if (!globals.contains(topRef)) {
                    for (String globalAlias : globals) {
                        Expression newExpr = ParseTreeKB.withTopRef(e, globalAlias);
                        if (op != null) {
                            newExpr = Operation.create(UNK, op, newExpr);
                        }
                        this.addFactInt(newExpr, (Fact)fe.b);
                    }
                    continue;
                }
                if (op != null || !(e instanceof Operation) || !((Fact)fe.b).isFalse() && !((Fact)fe.b).isTruthy()) continue;
                Expression newExpr = ParseTreeKB.withoutTopRef(e);
                this.addFactInt(newExpr, (Fact)fe.b);
            }
        }
        this.needsInference = false;
    }

    private void addFuzzyFact(Expression e, boolean isTruthy) {
        this.addFactInt(e, isTruthy ? Fact.TRUTHY : Fact.FALSEY);
    }

    protected void putFact(Expression e, String digest, Fact fact) {
        if (digest.length() > this.longestKeyLength) {
            this.longestKeyLength = digest.length();
        }
        this.facts.put(digest, Pair.pair((Expression)e.clone(), fact));
        this.needsInference = true;
    }

    private void optimize(Scope s, ParseTreeNode node, boolean isFuzzy, boolean isLhs, boolean throwsOnUndefined, boolean isFn, Result out) {
        Expression folded;
        String digest;
        List<? extends ParseTreeNode> children;
        int n;
        Operator op;
        if (node instanceof Conditional) {
            this.optimizeConditional(s, (Conditional)node, 0, out);
            return;
        }
        if (node instanceof Operation && Operator.MEMBER_ACCESS == (op = ((Operation)node).getOperator())) {
            this.optimizeMemberAccess(s, (Operation)node, isFuzzy, isLhs, throwsOnUndefined, out);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        if (node instanceof Reference) {
            if (!s.isOuter(((Reference)node).getIdentifierName())) {
                sb = null;
            }
        } else if (node instanceof FunctionConstructor) {
            s = Scope.fromFunctionConstructor(s, (FunctionConstructor)node);
        } else if (node instanceof CatchStmt) {
            s = Scope.fromCatchStmt(s, (CatchStmt)node);
        }
        if ((n = (children = node.children()).size()) != 0) {
            int fuzzyLimit = 0;
            int lhsLimit = 0;
            int touLimit = 0;
            int fnLimit = 0;
            if (node instanceof Operation) {
                Operator op2 = ((Operation)node).getOperator();
                switch (op2) {
                    case LOGICAL_AND: 
                    case LOGICAL_OR: {
                        fuzzyLimit = isFuzzy ? 2 : 0;
                        break;
                    }
                    case TERNARY: {
                        fuzzyLimit = isFuzzy ? 3 : 1;
                        break;
                    }
                    case NOT: {
                        fuzzyLimit = 1;
                        break;
                    }
                    case FUNCTION_CALL: {
                        fnLimit = 1;
                    }
                    case MEMBER_ACCESS: 
                    case SQUARE_BRACKET: 
                    case CONSTRUCTOR: {
                        touLimit = 1;
                        break;
                    }
                }
                if (op2.getCategory() == OperatorCategory.ASSIGNMENT) {
                    lhsLimit = 1;
                }
            }
            ParseTreeNode[] newChildren = null;
            for (int i = 0; i < n; ++i) {
                ParseTreeNode child = children.get(i);
                this.optimize(s, child, i < fuzzyLimit, i < lhsLimit, i < touLimit, i < fnLimit, out);
                sb = this.addDigest(out.digest, sb);
                if (out.node == child) continue;
                if (newChildren == null) {
                    newChildren = children.toArray(new ParseTreeNode[n]);
                }
                newChildren[i] = out.node;
            }
            if (newChildren != null) {
                node = ParseTreeNodes.newNodeInstance(node.getClass(), node.getFilePosition(), node.getValue(), Arrays.asList(newChildren));
            }
        }
        if (sb != null) {
            ParseTreeKB.nodeTail((ParseTreeNode)node, sb);
            digest = sb.toString();
            if (node instanceof Expression && !isLhs) {
                Fact f = this.getFact(digest);
                if (f == null) {
                    f = this.foldComparisonToFalsey((ParseTreeNode)node);
                }
                if (f != null && f.isSubstitutable(isFuzzy)) {
                    node = f.value.clone();
                    digest = this.optNodeDigest((ParseTreeNode)node);
                }
            }
        } else {
            digest = null;
        }
        if (node instanceof Expression && (folded = ParseTreeKB.normNum(((Expression)node).fold(isFn))) != node) {
            node = folded;
            digest = this.optNodeDigest(folded);
        }
        out.node = node;
        out.digest = digest;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void optimizeConditional(Scope s, Conditional c, int i, Result out) {
        List<? extends ParseTreeNode> children = c.children();
        int n = children.size();
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        int nEmitted = i;
        List<ParseTreeNode> newChildren = null;
        if (i != 0) {
            newChildren = Lists.newArrayList(n);
        }
        while (i < n) {
            String newDigest;
            block18: {
                Boolean optCond;
                ParseTreeNode child = children.get(i);
                this.optimize(s, child, true, false, false, false, out);
                ParseTreeNode newChild = out.node;
                newDigest = out.digest;
                Boolean bl = optCond = (i & 1) == 0 && i + 1 < n ? ((Expression)newChild).conditionResult() : null;
                if (optCond != null || child != newChild) {
                    if (newChildren == null) {
                        newChildren = Lists.newArrayList(n);
                    }
                    newChildren.addAll(children.subList(nEmitted, i));
                    if (optCond != null) {
                        Expression sideEffect = ((Expression)newChild).simplifyForSideEffect();
                        if (sideEffect == null) {
                            if (!optCond.booleanValue()) {
                                nEmitted = i += 2;
                                continue;
                            }
                            nEmitted = i + 1;
                            n = i + 2;
                            break block18;
                        } else {
                            if (optCond.booleanValue()) {
                                this.optimize(s, children.get(i + 1), false, false, false, false, out);
                            } else {
                                this.optimizeConditional(s, c, i + 2, out);
                            }
                            List<? extends Statement> stmts = Lists.newArrayList();
                            stmts.add(new ExpressionStmt(sideEffect));
                            if (out.node instanceof Block) {
                                stmts.addAll(((Block)out.node).children());
                            } else if (!(out.node instanceof Noop)) {
                                stmts.add((Statement)out.node);
                            }
                            if (!stmts.isEmpty()) {
                                newChildren.add(stmts.size() == 1 ? (Statement)stmts.get(0) : new Block(UNK, stmts));
                            }
                            sb = this.addDigest(newDigest, sb);
                            sb = this.addDigest(out.digest, sb);
                            n = nEmitted = i + 1;
                            break;
                        }
                    }
                    newChildren.add(newChild);
                    nEmitted = i + 1;
                }
            }
            sb = this.addDigest(newDigest, sb);
            ++i;
        }
        if (sb != null) {
            ParseTreeKB.nodeTail(c, sb);
        }
        if (newChildren != null) {
            if (nEmitted < n) {
                newChildren.addAll(children.subList(nEmitted, n));
            }
            if (newChildren.size() < 2) {
                out.node = newChildren.isEmpty() ? new Noop(UNK) : (Statement)newChildren.get(0);
                out.digest = this.optNodeDigest(out.node);
                return;
            }
            out.node = new Conditional(UNK, null, newChildren);
            out.digest = sb != null ? sb.toString() : null;
            return;
        }
        out.node = c;
        out.digest = sb != null ? sb.toString() : null;
    }

    private void optimizeMemberAccess(Scope s, Operation ma, boolean isFuzzy, boolean isLhs, boolean throwsOnUndefined, Result out) {
        int objDigestEnd;
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        Expression obj = ma.children().get(0);
        this.optimize(s, obj, false, false, false, false, out);
        Reference prop = (Reference)ma.children().get(1);
        if (out.node != obj) {
            ma = Operation.createInfix(Operator.MEMBER_ACCESS, (Expression)out.node, prop);
        }
        int n = objDigestEnd = (sb = this.addDigest(out.digest, sb)) != null ? sb.length() : -1;
        if (sb != null) {
            ParseTreeKB.nodeDigest(ma.children().get(1), sb);
            ParseTreeKB.nodeTail(ma, sb);
        }
        String digest = sb != null ? sb.toString() : null;
        out.node = ma;
        out.digest = digest;
        if (digest != null) {
            Fact f;
            if (!isLhs && (f = this.getFact(digest)) != null && f.isSubstitutable(isFuzzy)) {
                out.node = f.value.clone();
                out.digest = ParseTreeKB.nodeDigest(out.node);
                return;
            }
            String objDigest = digest.substring(1, objDigestEnd);
            Pair<Expression, Fact> objFe = this.facts.get(objDigest);
            if (objFe != null && ((Fact)objFe.b).isGlobal() && s.isOuter(prop.getIdentifierName())) {
                String propDigest = ParseTreeKB.nodeDigest(prop);
                boolean canSimplify = false;
                if (isLhs || throwsOnUndefined) {
                    canSimplify = true;
                } else {
                    Pair<Expression, Fact> propFe = this.facts.get(propDigest);
                    if (propFe != null) {
                        Fact pf = (Fact)propFe.b;
                        boolean bl = canSimplify = pf.isTruthy() || pf.type == Fact.Type.IS && !pf.isUndefined();
                    }
                }
                if (canSimplify) {
                    out.node = prop;
                    out.digest = propDigest;
                }
            }
        }
    }

    private StringBuilder addDigest(String digest, StringBuilder out) {
        if (digest != null && out != null && out.length() + digest.length() <= this.longestKeyLength) {
            return out.append(digest);
        }
        return null;
    }

    private static String nodeDigest(ParseTreeNode node) {
        StringBuilder sb = new StringBuilder();
        ParseTreeKB.nodeDigest(node, sb);
        return sb.toString();
    }

    private String optNodeDigest(ParseTreeNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (ParseTreeNode parseTreeNode : node.children()) {
            ParseTreeKB.nodeDigest(parseTreeNode, sb);
            if (sb.length() <= this.longestKeyLength) continue;
            return null;
        }
        ParseTreeKB.nodeTail(node, sb);
        if (sb.length() > this.longestKeyLength) {
            return null;
        }
        return sb.toString();
    }

    private Fact foldComparisonToFalsey(ParseTreeNode n) {
        Pair<Expression, Fact> fe;
        boolean eq;
        if (!(n instanceof Operation)) {
            return null;
        }
        Operation op = (Operation)n;
        Operator o = op.getOperator();
        switch (o) {
            case EQUAL: 
            case STRICTLY_EQUAL: {
                eq = true;
                break;
            }
            case NOT_EQUAL: 
            case STRICTLY_NOT_EQUAL: {
                eq = false;
                break;
            }
            default: {
                return null;
            }
        }
        boolean strict = o == Operator.STRICTLY_EQUAL || o == Operator.STRICTLY_NOT_EQUAL;
        List<? extends Expression> operands = op.children();
        Expression a = operands.get(0);
        Expression b = operands.get(1);
        if (!(!strict ? ParseTreeKB.isNullOrUndef(a) : ParseTreeKB.isUndefOrLiteral(a))) {
            if (strict ? ParseTreeKB.isUndefOrLiteral(b) : ParseTreeKB.isNullOrUndef(b)) {
                Expression t = a;
                a = b;
                b = t;
            } else {
                return null;
            }
        }
        if ((fe = this.facts.get(this.optNodeDigest(b))) == null) {
            return null;
        }
        Boolean bool = a.conditionResult();
        if (bool == null || bool.booleanValue() == ((Fact)fe.b).isTruthy()) {
            return null;
        }
        return eq ? Fact.FALSE : Fact.TRUE;
    }

    private static boolean isUndefOrLiteral(Expression e) {
        if (e instanceof Literal) {
            return true;
        }
        return Operation.is((ParseTreeNode)e, Operator.VOID) && e.simplifyForSideEffect() == null;
    }

    private static boolean isNullOrUndef(Expression e) {
        if (e instanceof NullLiteral) {
            return true;
        }
        return Operation.is((ParseTreeNode)e, Operator.VOID) && e.simplifyForSideEffect() == null;
    }

    private static void nodeDigest(ParseTreeNode n, StringBuilder out) {
        out.append('(');
        for (ParseTreeNode parseTreeNode : n.children()) {
            ParseTreeKB.nodeDigest(parseTreeNode, out);
        }
        ParseTreeKB.nodeTail(n, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void nodeTail(ParseTreeNode n, StringBuilder out) {
        Object value;
        String idx;
        Class<?> clazz = n.getClass();
        Map<Class<?>, String> map = CLASS_NAME_DIGEST_IDX;
        synchronized (map) {
            idx = CLASS_NAME_DIGEST_IDX.get(clazz);
            if (idx == null) {
                idx = CLASS_NAME_DIGEST_IDX.size() + ":";
                CLASS_NAME_DIGEST_IDX.put(clazz, idx);
            }
        }
        out.append(idx);
        Object object = value = n instanceof StringLiteral ? ((StringLiteral)n).getValue() : n.getValue();
        if (value != null) {
            out.append(n.getValue());
            for (int start = out.length(); start < out.length(); ++start) {
                char ch = out.charAt(start);
                if (ch != '(' && ch != ')' && ch != '*') continue;
                out.insert(start, '*');
                ++start;
            }
        }
        out.append(')');
    }

    private static boolean isThis(ParseTreeNode node) {
        if (!(node instanceof Reference)) {
            return false;
        }
        return "this".equals(((Reference)node).getIdentifierName());
    }

    private static String topRef(Expression e) {
        block3: while (true) {
            if (e instanceof Reference) {
                return ((Reference)e).getIdentifierName();
            }
            if (!(e instanceof Operation)) {
                return null;
            }
            Operation op = (Operation)e;
            switch (op.getOperator()) {
                case MEMBER_ACCESS: 
                case SQUARE_BRACKET: {
                    e = op.children().get(0);
                    continue block3;
                }
            }
            break;
        }
        return null;
    }

    private static Expression withTopRef(Expression e, String lhs) {
        if (e instanceof Reference) {
            return Operation.createInfix(Operator.MEMBER_ACCESS, new Reference(new Identifier(UNK, lhs)), e);
        }
        Operation op = (Operation)e;
        List<? extends Expression> operands = op.children();
        return Operation.create(e.getFilePosition(), op.getOperator(), ParseTreeKB.withTopRef(operands.get(0), lhs), operands.get(1));
    }

    private static Expression withoutTopRef(Expression e) {
        Operation op = (Operation)e;
        List<? extends Expression> operands = op.children();
        Expression obj = operands.get(0);
        Expression prop = operands.get(1);
        if (obj instanceof Reference) {
            return prop;
        }
        return Operation.create(e.getFilePosition(), op.getOperator(), ParseTreeKB.withoutTopRef(obj), prop);
    }

    private static Expression rfold(Expression e, boolean isFn) {
        if (e instanceof Operation) {
            Operation o = (Operation)e;
            List<? extends Expression> children = o.children();
            Expression[] newChildren = null;
            boolean oIsFn = o.getOperator() == Operator.FUNCTION_CALL;
            int n = children.size();
            for (int i = 0; i < n; ++i) {
                Expression newOperand;
                Expression operand = children.get(i);
                if (operand == (newOperand = ParseTreeKB.rfold(operand, oIsFn && i == 0))) continue;
                if (newChildren == null) {
                    newChildren = children.toArray(new Expression[n]);
                }
                newChildren[i] = newOperand;
            }
            if (newChildren != null) {
                e = Operation.create(e.getFilePosition(), o.getOperator(), newChildren);
            }
        }
        return ParseTreeKB.normNum(e.fold(isFn));
    }

    private static Expression normNum(Expression e) {
        long lv;
        if (!(e instanceof RealLiteral)) {
            return e;
        }
        RealLiteral rl = (RealLiteral)e;
        Number n = rl.getValue();
        double dv = n.doubleValue();
        if (dv == (double)(lv = n.longValue()) && (dv != 0.0 || 1.0 / dv == Double.POSITIVE_INFINITY)) {
            return new IntegerLiteral(rl.getFilePosition(), lv);
        }
        return rl;
    }

    static {
        for (Operator op : new Operator[]{Operator.BITWISE_AND, Operator.BITWISE_OR, Operator.BITWISE_XOR, Operator.EQUAL, Operator.MULTIPLICATION, Operator.NOT_EQUAL, Operator.STRICTLY_EQUAL, Operator.STRICTLY_NOT_EQUAL}) {
            WITH_REVERSE_ORDER.put(op, op);
        }
        WITH_REVERSE_ORDER.put(Operator.GREATER_EQUALS, Operator.LESS_EQUALS);
        WITH_REVERSE_ORDER.put(Operator.LESS_EQUALS, Operator.GREATER_EQUALS);
        WITH_REVERSE_ORDER.put(Operator.GREATER_THAN, Operator.LESS_THAN);
        WITH_REVERSE_ORDER.put(Operator.LESS_THAN, Operator.GREATER_THAN);
        CLASS_NAME_DIGEST_IDX = Collections.synchronizedMap(Maps.newHashMap());
    }

    private static class Result {
        String digest;
        ParseTreeNode node;

        private Result() {
        }
    }
}

