/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.Glob;
import com.google.caja.util.CajaTestCase;
import java.util.regex.Pattern;

public class GlobTest
extends CajaTestCase {
    public final void testGlobToRegex() {
        this.assertGlob("", "");
        this.assertGlob("\\Qfoo\\E", "foo");
        this.assertGlob("\\Qfoo\\E.*", "foo*");
        this.assertGlob("\\Qfoo\\E.*\\Qbar\\E", "foo*bar");
        this.assertGlob("\\Qfoo\\E.", "foo?");
        this.assertGlob("\\Qfoo\\E.\\Qbar\\E", "foo?bar");
        this.assertGlob("\\Qfoo\\E\\Q*bar\\E", "foo\\*bar");
        this.assertGlob("\\Qfoo\\E\\Q?\\E", "foo\\?");
        this.assertGlob("\\Qfoo\\E\\Qn\\E", "foo\\n", "foon");
        this.assertGlob("\\Qfoo\\E\\QQ\\E", "foo\\Q", "fooQ");
    }

    public final void testRegexToGlob() {
        GlobTest.assertEquals((String)"foo?*bar", (String)Glob.regexToGlob(Pattern.compile("foo.+bar")));
        this.assertNotConvertibleToGlob("(foo)");
        this.assertNotConvertibleToGlob("[foo]");
        this.assertNotConvertibleToGlob("foo{2}");
        this.assertNotConvertibleToGlob("^foo");
        this.assertNotConvertibleToGlob("foo$");
    }

    private void assertGlob(String regex, String glob) {
        this.assertGlob(regex, glob, glob);
    }

    private void assertGlob(String regex, String glob, String normGlob) {
        Pattern p = Glob.globToRegex(glob);
        GlobTest.assertEquals((String)regex, (String)p.pattern());
        GlobTest.assertEquals((String)normGlob, (String)Glob.regexToGlob(p));
    }

    private void assertNotConvertibleToGlob(String regex) {
        Pattern p = Pattern.compile(regex);
        try {
            Glob.regexToGlob(p);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        GlobTest.fail((String)("Not convertible to regex: " + regex));
    }
}

