/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.Request;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.html.HtmlQuasiBuilder;
import com.google.caja.parser.html.Nodes;
import com.google.caja.reporting.HtmlSnippetProducer;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.Lists;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class Reporter {
    private static final Comparator<Message> MESSAGE_COMPARATOR = new Comparator<Message>(){

        @Override
        public int compare(Message a, Message b) {
            int delta = this.compare(this.firstPart(a), this.firstPart(b));
            if (delta == 0) {
                delta = a.getMessageType().name().compareTo(b.getMessageType().name());
            }
            return delta;
        }

        private MessagePart firstPart(Message m) {
            List<MessagePart> parts = m.getMessageParts();
            if (parts.isEmpty()) {
                return null;
            }
            return parts.get(0);
        }

        @Override
        private int compare(MessagePart a, MessagePart b) {
            int delta;
            FilePosition p;
            if (a == null) {
                return b == null ? 0 : -1;
            }
            if (b == null) {
                return 1;
            }
            URI aUri = null;
            URI bUri = null;
            int aStart = -1;
            int bStart = -1;
            int aEnd = -1;
            int bEnd = -1;
            if (a instanceof FilePosition) {
                p = (FilePosition)a;
                aUri = p.source().getUri();
                aStart = p.startCharInFile();
                aEnd = p.endCharInFile();
            } else if (a instanceof InputSource) {
                aUri = ((InputSource)a).getUri();
            }
            if (b instanceof FilePosition) {
                p = (FilePosition)b;
                bUri = p.source().getUri();
                bStart = p.startCharInFile();
                bEnd = p.endCharInFile();
            } else if (b instanceof InputSource) {
                bUri = ((InputSource)b).getUri();
            }
            int n = aUri != null ? (bUri != null ? aUri.compareTo(bUri) : -1) : (delta = bUri != null ? 1 : 0);
            if (delta == 0 && (delta = Long.signum((long)aStart - (long)bStart)) == 0) {
                delta = Long.signum((long)aEnd - (long)bEnd);
            }
            return delta;
        }
    };

    Reporter() {
    }

    static DocumentFragment messagesToFragment(MessageQueue mq, Request req, HtmlQuasiBuilder b) {
        HtmlSnippetProducer sr = new HtmlSnippetProducer(req.srcMap, req.mc);
        DocumentFragment f = b.getDocument().createDocumentFragment();
        List<Message> messages = Lists.newArrayList(mq.getMessages());
        Collections.sort(messages, MESSAGE_COMPARATOR);
        for (Message msg : messages) {
            if (msg.getMessageLevel().compareTo(req.minLevel) < 0 || req.toIgnore.contains(msg.getMessageType().name())) continue;
            Node help = null;
            String helpFile = msg.getMessageType().name() + "_tip.html";
            if (req.staticFiles.exists("files/" + helpFile)) {
                help = b.substV(" <a class=help href=files-@cid/@helpPath target=help>&#xff1f;</a>", "helpPath", helpFile, "cid", req.staticFiles.cacheId);
            }
            String snippetHtml = sr.getSnippet(msg);
            Element snippet = null;
            if (snippetHtml != null) {
                try {
                    DocumentFragment snippetF = b.toFragment(snippetHtml);
                    snippet = b.getDocument().createElementNS("http://www.w3.org/1999/xhtml", "pre");
                    snippet.setAttributeNS("http://www.w3.org/1999/xhtml", "class", "prettyprint snippet");
                    for (Node node : Nodes.childrenOf(snippetF)) {
                        snippet.appendChild(node);
                    }
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
            }
            f.appendChild(b.substV("<h4 title=@msgname>@text @help</h4>@snippet", "msgname", msg.getMessageType().name(), "text", msg.getMessageLevel().name() + ": " + msg.format(req.mc), "help", help != null ? help : "", "snippet", snippet != null ? snippet : ""));
        }
        return f;
    }
}

