/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.css;

import com.google.caja.lang.css.JSRE;
import junit.framework.TestCase;

public class JSRETest
extends TestCase {
    public final void testOptimize() {
        JSRETest.assertOptimized("foo", JSRE.lit("foo"));
        JSRETest.assertOptimized("foo", JSRE.raw("foo"));
        JSRETest.assertEquals((String)"(?:fo)(?:o)*", (String)("" + JSRE.cat(JSRE.lit("fo"), JSRE.any(JSRE.lit("o")))));
        JSRETest.assertOptimized("fo+", JSRE.cat(JSRE.lit("fo"), JSRE.any(JSRE.lit("o"))));
        JSRETest.assertOptimized("bar\\\\baz", JSRE.lit("bar\\baz"));
        JSRETest.assertOptimized("bar\\baz", JSRE.raw("bar\\baz"));
        JSRETest.assertOptimized("foo|bar", JSRE.alt(JSRE.lit("foo"), JSRE.lit("bar")));
        JSRETest.assertOptimized("b(?:a|ee)r", JSRE.alt(JSRE.lit("bar"), JSRE.lit("beer")));
        JSRETest.assertOptimized("be[ae]r", JSRE.alt(JSRE.lit("bear"), JSRE.lit("beer")));
        JSRETest.assertOptimized("a[+\\-\\n]b", JSRE.alt(JSRE.lit("a+b"), JSRE.lit("a-b"), JSRE.cat(JSRE.raw("a"), JSRE.raw("\\n"), JSRE.raw("b"))));
        JSRETest.assertOptimized("barn?", JSRE.alt(JSRE.lit("bar"), JSRE.lit("barn")));
        JSRETest.assertOptimized("b?ear", JSRE.alt(JSRE.lit("bear"), JSRE.lit("ear")));
        JSRETest.assertOptimized("", JSRE.alt(JSRE.cat(new JSRE[0]), JSRE.lit(""), JSRE.raw("")));
        JSRETest.assertOptimized("(?:foo)?", JSRE.opt(JSRE.lit("foo")));
        JSRETest.assertOptimized("(?:foo)+", JSRE.many(JSRE.lit("foo")));
        JSRETest.assertOptimized("(?:foo)*", JSRE.any(JSRE.lit("foo")));
        JSRE x = JSRE.lit("x");
        JSRETest.assertOptimized("x?", JSRE.opt(JSRE.opt(x)));
        JSRETest.assertOptimized("x*", JSRE.many(JSRE.opt(x)));
        JSRETest.assertOptimized("x*", JSRE.any(JSRE.opt(x)));
        JSRETest.assertOptimized("x*", JSRE.rep(JSRE.opt(x), 2, Integer.MAX_VALUE));
        JSRETest.assertOptimized("x{0,4}", JSRE.rep(JSRE.opt(x), 2, 4));
        JSRETest.assertOptimized("x*", JSRE.opt(JSRE.any(x)));
        JSRETest.assertOptimized("x*", JSRE.any(JSRE.any(x)));
        JSRETest.assertOptimized("x*", JSRE.many(JSRE.any(x)));
        JSRETest.assertOptimized("x*", JSRE.rep(JSRE.any(x), 2, 3));
        JSRETest.assertOptimized("x*", JSRE.opt(JSRE.many(x)));
        JSRETest.assertOptimized("x*", JSRE.any(JSRE.many(x)));
        JSRETest.assertOptimized("x+", JSRE.many(JSRE.many(x)));
        JSRETest.assertOptimized("x{2,}", JSRE.rep(JSRE.many(x), 2, 4));
        JSRETest.assertOptimized("(?:x{2,4})*", JSRE.any(JSRE.rep(x, 2, 4)));
        JSRETest.assertOptimized("(?:x{2,4})+", JSRE.many(JSRE.rep(x, 2, 4)));
        JSRETest.assertOptimized("(?:x{2,4})?", JSRE.opt(JSRE.rep(x, 2, 4)));
        JSRETest.assertOptimized("(?:x{2,4}){1,3}", JSRE.rep(JSRE.rep(x, 2, 4), 1, 3));
        JSRETest.assertOptimized("x{2,}", JSRE.rep(x, 2, Integer.MAX_VALUE));
        JSRETest.assertOptimized("x{0,4}", JSRE.rep(x, 0, 4));
        JSRETest.assertEquals((String)"(?:foo)(?:foo)*", (String)("" + JSRE.cat(JSRE.lit("foo"), JSRE.any(JSRE.lit("foo")))));
        JSRETest.assertOptimized("(?:foo)+", JSRE.cat(JSRE.lit("foo"), JSRE.any(JSRE.lit("foo"))));
        JSRETest.assertOptimized("(?:foo)+", JSRE.cat(JSRE.any(JSRE.lit("foo")), JSRE.lit("foo")));
        JSRETest.assertOptimized("foo|ba[rz]", JSRE.alt(JSRE.lit("foo"), JSRE.alt(JSRE.lit("bar"), JSRE.lit("baz"))));
        JSRETest.assertOptimized("foo|bar|ak", JSRE.alt(JSRE.lit("foo"), JSRE.alt(JSRE.lit("bar"), JSRE.lit("ak"))));
        JSRETest.assertOptimized("[xy]", JSRE.alt(x, x, x, JSRE.lit("y"), x));
        JSRE noop = JSRE.lit("");
        JSRETest.assertOptimized("[xy]?", JSRE.alt(x, noop, x, JSRE.lit("y"), x, noop));
        JSRETest.assertOptimized("a(?:bac){1,2}", JSRE.alt(JSRE.lit("abacbac"), JSRE.lit("abac")));
        JSRETest.assertOptimized("a(?:bac){1,2}", JSRE.alt(JSRE.lit("abac"), JSRE.lit("abacbac")));
        JSRETest.assertOptimized("ab", JSRE.cat(JSRE.lit("a"), noop, JSRE.lit("b")));
        JSRETest.assertOptimized("foo", JSRE.rep(JSRE.lit("foo"), 1, 1));
        JSRETest.assertOptimized("", JSRE.opt(noop));
        JSRETest.assertOptimized("", JSRE.many(noop));
        JSRETest.assertOptimized("x*(?:foo)?", JSRE.cat(JSRE.any(x), JSRE.opt(JSRE.cat(JSRE.any(x), JSRE.lit("foo")))));
        JSRETest.assertOptimized("[ab]", JSRE.alt(JSRE.lit("a"), JSRE.lit("b")));
        JSRETest.assertOptimized("[ab]", JSRE.alt(JSRE.lit("b"), JSRE.lit("a")));
        JSRETest.assertOptimized("[a-c]", JSRE.alt(JSRE.lit("a"), JSRE.lit("b"), JSRE.lit("c")));
        JSRETest.assertOptimized("[BCa-c]", JSRE.alt(JSRE.lit("b"), JSRE.lit("C"), JSRE.lit("a"), JSRE.lit("B"), JSRE.lit("c")));
        JSRETest.assertOptimized("[ACa-c]", JSRE.alt(JSRE.lit("b"), JSRE.lit("A"), JSRE.lit("a"), JSRE.lit("C"), JSRE.lit("c")));
    }

    private static void assertOptimized(String regex, JSRE p) {
        JSRETest.assertEquals((Object)p, (Object)p);
        JSRE optimized = p.optimize();
        JSRETest.assertEquals((Object)optimized, (Object)optimized);
        JSRETest.assertEquals((String)regex, (String)("" + optimized));
    }
}

