/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.parser.html.Nodes;
import com.google.caja.plugin.templates.TemplateSanitizer;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.MoreAsserts;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Node;

public class TemplateSanitizerTest
extends CajaTestCase {
    public final void testSingleElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<br/>")), "<br />", new String[0]);
    }

    public final void testText() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("Hello World")), "Hello World", new String[0]);
    }

    public final void testFormattingElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<b>Hello</b>")), "<b>Hello</b>", new String[0]);
    }

    public final void testUnknownAttribute() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<b unknown=\"bogus\">Hello</b>")), "<b>Hello</b>", "WARNING: removing unknown attribute unknown on b");
    }

    public final void testKnownAttribute() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<b id=\"bold\">Hello</b>")), "<b id=\"bold\">Hello</b>", new String[0]);
    }

    public final void testUnknownElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<bogus id=\"bold\">Hello</bogus>")), "Hello", "WARNING: removing unknown tag bogus", "WARNING: removing attribute id when folding bogus into parent");
    }

    public final void testUnknownEverything() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<bogus unknown=\"bogus\">Hello</bogus>")), "Hello", "WARNING: removing unknown tag bogus");
    }

    public final void testDisallowedScriptElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<script>disallowed</script>")), "disallowed", "WARNING: removing disallowed tag script");
        this.assertValid(this.htmlFragment(this.fromString("<script src=http://can-link-to.com/ >disallowed</script>")), "disallowed", "WARNING: removing disallowed tag script");
    }

    public final void testDisallowedAppletElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<applet><param name=zoicks value=ack><a href=http://can-link-to.com/ >disallowed</a></applet>")), "<a href=\"http://can-link-to.com/\">disallowed</a>", "WARNING: removing disallowed tag applet", "WARNING: removing disallowed tag param");
    }

    public final void testDisallowedBaseElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<base href='http://can-link-to.com/'>disallowed")), "disallowed", "WARNING: removing disallowed tag base");
    }

    public final void testDisallowedBasefontElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<basefont size=4>disallowed")), "disallowed", "WARNING: removing disallowed tag basefont");
    }

    public final void testDisallowedFrameElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<frameset><frame src='http://can-link-to.com/'>disallowed</frame></frameset>")), "", "WARNING: removing disallowed tag frameset", "WARNING: removing disallowed tag frame");
        this.assertValid(this.htmlFragment(this.fromString("<frame src='http://can-link-to.com/'>disallowed</frame>")), "disallowed", new String[0]);
    }

    public final void testDisallowedFramesetElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<frameset>disallowed</frameset>")), "", "WARNING: removing disallowed tag frameset");
    }

    public final void testDisallowedIframeElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<iframe src='http://can-link-to.com/' name='foo' id='bar' width=3>disallowed</iframe>")), "<iframe width=\"3\">disallowed</iframe>", "WARNING: removing disallowed attribute src on tag iframe", "WARNING: removing disallowed attribute name on tag iframe", "WARNING: removing disallowed attribute id on tag iframe");
    }

    public final void testIsindexElementRewrittenSafely() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<isindex name=foo>rewritten")), "<form><hr /><p><label>This is a searchable index. Insert your search keywords here: <input name=\"isindex\" /></label></p><hr /></form>rewritten", new String[0]);
    }

    public final void testDisallowedLinkElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<link rev=Contents href='http://can-link-to.com/'>disallowed")), "disallowed", "WARNING: removing disallowed tag link");
    }

    public final void testDisallowedMetaElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<meta http-equiv='refresh' content='5;url=http://can-link-to.com/'>disallowed")), "disallowed", "WARNING: removing disallowed tag meta");
    }

    public final void testDisallowedObjectElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<object><param name=zoicks value=ack>disallowed</object>")), "disallowed", "WARNING: removing disallowed tag object", "WARNING: removing disallowed tag param");
    }

    public final void testDisallowedStyleElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<style>p { color: expression(disallowed()) }</style>")), "p { color: expression(disallowed()) }", "WARNING: removing disallowed tag style");
    }

    public final void testDisallowedTitleElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<title>disallowed</title>")), "", "WARNING: removing disallowed tag title");
    }

    public final void testAttributeValidity() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<form><input type=text></form>")), "<form><input type=\"text\" /></form>", new String[0]);
    }

    public final void testAttributePatternsTagSpecific() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<input type=text>")), "<input type=\"text\" />", new String[0]);
        this.assertValid(this.htmlFragment(this.fromString("<button type=submit>")), "<button type=\"submit\" />", new String[0]);
        this.assertValid(this.htmlFragment(this.fromString("<BUTTON TYPE=SUBMIT>")), "<button type=\"SUBMIT\" />", new String[0]);
        this.assertValid(this.htmlFragment(this.fromString("<button type=text>")), "<button />", "WARNING: attribute type cannot have value text");
        this.assertValid(this.htmlFragment(this.fromString("<BUTTON TYPE=TEXT>")), "<button />", "WARNING: attribute type cannot have value TEXT");
    }

    public final void testIllegalAttributeValue() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<form><input type=x></form>")), "<form><input /></form>", "WARNING: attribute type cannot have value x");
    }

    public final void testDisallowedElement2() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<xmp>disallowed</xmp>")), "disallowed", "WARNING: removing unknown tag xmp");
    }

    public final void testDisallowedElement3() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<meta http-equiv='refresh' content='1'/>")), "", "WARNING: removing disallowed tag meta");
    }

    public final void testDisallowedElement4() throws Exception {
        this.assertValid(this.xmlFragment(this.fromString("<title>A title</title>")), "", "WARNING: removing disallowed tag title");
    }

    public final void testElementFolding1() throws Exception {
        this.assertValid(this.xmlFragment(this.fromString("<body bgcolor=\"red\">Zoicks</body>")), "Zoicks", "WARNING: folding element body into parent", "WARNING: removing attribute bgcolor when folding body into parent");
    }

    public final void testElementFolding2() throws Exception {
        this.assertValid(this.xmlFragment(this.fromString("<body>Zoicks</body>")), "Zoicks", "WARNING: folding element body into parent");
    }

    public final void testElementFolding3() throws Exception {
        this.assertValid(this.xmlFragment(this.fromString("<html><head><title>Blah</title><p>Foo</p></head><body><p>One</p><p styleo=\"color: red\">Two</p>Three<x>Four</x></body></html>")), "<p>Foo</p><p>One</p><p>Two</p>ThreeFour", "WARNING: folding element html into parent", "WARNING: folding element head into parent", "WARNING: removing disallowed tag title", "WARNING: folding element body into parent", "WARNING: removing unknown attribute styleo on p", "WARNING: removing unknown tag x");
    }

    public final void testElementFolding4() throws Exception {
        this.assertValid(this.xmlFragment(this.fromString("<html><head><title>Blah</title><p>Foo</p></head><body><p>One</p><p>Two</p>Three<p>Four</p></body></html>")), "<p>Foo</p><p>One</p><p>Two</p>Three<p>Four</p>", "WARNING: folding element html into parent", "WARNING: folding element head into parent", "WARNING: removing disallowed tag title", "WARNING: folding element body into parent");
    }

    public final void testIgnoredElement() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<p>Foo<noscript>ignorable</noscript><p>Bar")), "<p>Foo</p><p>Bar</p>", "WARNING: removing disallowed tag noscript");
    }

    public final void testDupeAttrs() throws Exception {
        this.assertValid(this.xmlFragment(this.fromString("<font color=\"red\" color=\"blue\">Purple</font>")), "<font color=\"red\">Purple</font>", "WARNING: attribute color duplicates one at testDupeAttrs:1+7 - 12");
    }

    public final void testDisallowedAttrs() throws Exception {
        this.assertValid(this.htmlFragment(this.fromString("<a href=\"foo.html\" charset=\"utf-7\">foo</a>")), "<a href=\"foo.html\">foo</a>", "WARNING: removing disallowed attribute charset on tag a");
    }

    public final void testStrangeIds() throws Exception {
        String html = "<input name=\"tag[]\" />\n<input name=\"form$location\" />\n<span id=\"23skiddoo\">a</span>\n<span id=\"8675309\">b</span>\n";
        this.assertValid(this.htmlFragment(this.fromString(html)), html, new String[0]);
    }

    private void assertValid(Node input, String golden, String ... warnings) {
        this.sanitize(input, golden, true, warnings);
    }

    private void sanitize(Node input, String golden, boolean valid, String ... warnings) {
        boolean validated = new TemplateSanitizer(HtmlSchema.getDefault(this.mq), this.mq).sanitize(input);
        ArrayList<String> actualWarnings = new ArrayList<String>();
        for (Message msg : this.mq.getMessages()) {
            if (MessageLevel.WARNING.compareTo(msg.getMessageLevel()) > 0) continue;
            String msgText = msg.format(this.mc);
            msgText = msgText.substring(msgText.indexOf(": ") + 1);
            actualWarnings.add(msg.getMessageLevel().name() + ":" + msgText);
        }
        this.mq.getMessages().clear();
        MoreAsserts.assertListsEqual(Arrays.asList(warnings), actualWarnings);
        TemplateSanitizerTest.assertEquals((boolean)valid, (boolean)validated);
        if (golden != null) {
            TemplateSanitizerTest.assertEquals((String)golden, (String)Nodes.render(input, true));
        }
    }
}

