/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.lexer.InputSource;
import com.google.caja.util.Abbreviator;
import com.google.caja.util.SyntheticAttributeKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageContext {
    private Collection<InputSource> inputSources = Collections.emptySet();
    private Abbreviator abbreviator;
    public Set<? extends SyntheticAttributeKey<?>> relevantKeys = Collections.emptySet();

    public Collection<InputSource> getInputSources() {
        return this.inputSources;
    }

    public void addInputSource(InputSource src) {
        if (this.inputSources.isEmpty()) {
            this.inputSources = new LinkedHashSet<InputSource>();
        }
        if (this.inputSources.add(src)) {
            this.abbreviator = null;
        }
    }

    public String abbreviate(InputSource toAbbreviate) {
        if (this.abbreviator == null) {
            HashSet<String> uris = new HashSet<String>();
            for (InputSource is : this.inputSources) {
                uris.add(is.getUri().toString());
            }
            this.abbreviator = new Abbreviator(uris, "/");
        }
        return this.abbreviator.unambiguousAbbreviationFor(toAbbreviate.getUri().toString());
    }
}

