/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.tools;

import com.google.caja.parser.quasiliteral.DojoRuleDoclet;
import com.google.caja.parser.quasiliteral.HtmlRuleDoclet;
import com.google.caja.parser.quasiliteral.JsonRuleDoclet;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.RuleDoclet;
import com.google.caja.parser.quasiliteral.TextRuleDoclet;
import com.google.caja.parser.quasiliteral.WikiRuleDoclet;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.Charsets;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocletAntTask
extends Task {
    private String outputDir;
    private RuleDoclet output;
    private Rewriter rewriter;

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setOutput(String output) {
        if (output.equals("text")) {
            this.output = new TextRuleDoclet();
        } else if (output.equals("html")) {
            this.output = new HtmlRuleDoclet();
        } else if (output.equals("json")) {
            this.output = new JsonRuleDoclet();
        } else if (output.equals("text")) {
            this.output = new WikiRuleDoclet();
        } else if (output.equals("dojo")) {
            this.output = new DojoRuleDoclet();
        } else {
            throw new BuildException("Unsupported doclet type");
        }
    }

    public void setRewriter(String className) {
        try {
            Class<Rewriter> rewriterClass = Class.forName(className).asSubclass(Rewriter.class);
            Constructor<Rewriter> ctor = DocletAntTask.publicCtor(rewriterClass);
            Object[] actuals = new Object[ctor.getParameterTypes().length];
            int i = 0;
            for (Class<?> ptype : ctor.getParameterTypes()) {
                if (Boolean.TYPE.equals(ptype)) {
                    actuals[i] = Boolean.FALSE;
                } else if (BuildInfo.class.isAssignableFrom(ptype)) {
                    actuals[i] = BuildInfo.getInstance();
                } else if (MessageQueue.class.isAssignableFrom(ptype)) {
                    actuals[i] = new SimpleMessageQueue();
                }
                ++i;
            }
            this.rewriter = ctor.newInstance(actuals);
        }
        catch (InstantiationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private static <T> Constructor<T> publicCtor(Class<T> cl) throws IllegalAccessException {
        for (Constructor<?> c : cl.getDeclaredConstructors()) {
            if (!Modifier.isPublic(c.getModifiers())) continue;
            return c;
        }
        throw new IllegalAccessException();
    }

    private void checkValidParameters() {
        if (null == this.output) {
            throw new BuildException("Doclet \"output\" type not set");
        }
        if (null == this.rewriter) {
            throw new BuildException("Doclet \"rewriter\" not set");
        }
        if (null == this.outputDir) {
            throw new BuildException("Doclet \"outputDir\" not set");
        }
    }

    private String getOutputFileName() {
        String simpleFileName = this.rewriter.getClass().getSimpleName();
        String dirFileName = this.outputDir.endsWith("/") ? this.outputDir + simpleFileName : this.outputDir + '/' + simpleFileName;
        String completeFileName = dirFileName + '.' + this.output.getDefaultExtension();
        return completeFileName;
    }

    public void execute() throws BuildException {
        try {
            this.checkValidParameters();
            this.output.setRewriter(this.rewriter);
            String outputFile = this.getOutputFileName();
            BufferedWriter outputStream = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), Charsets.UTF_8.name()));
            this.output.generateDocumentation(outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

