/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import java.util.Arrays;

public final class SparseBitSet {
    private final int[] ranges;
    public static final SparseBitSet EMPTY = SparseBitSet.withRanges(new int[0]);

    public static SparseBitSet withMembers(byte ... members) {
        return new SparseBitSet(SparseBitSet.intArrayToRanges(SparseBitSet.primitiveArrayToInts(members)));
    }

    public static SparseBitSet withMembers(char ... members) {
        return new SparseBitSet(SparseBitSet.intArrayToRanges(SparseBitSet.primitiveArrayToInts(members)));
    }

    public static SparseBitSet withMembers(short ... members) {
        return new SparseBitSet(SparseBitSet.intArrayToRanges(SparseBitSet.primitiveArrayToInts(members)));
    }

    public static SparseBitSet withMembers(int ... members) {
        return new SparseBitSet(SparseBitSet.intArrayToRanges(members));
    }

    public static SparseBitSet between(int start, int end) {
        if (start >= end) {
            throw new IndexOutOfBoundsException();
        }
        return new SparseBitSet(new int[]{start, end});
    }

    public static SparseBitSet withRanges(int ... ranges) {
        if (((ranges = (int[])ranges.clone()).length & 1) != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 1; i < ranges.length; ++i) {
            if (ranges[i] > ranges[i - 1]) continue;
            throw new IllegalArgumentException(ranges[i] + " > " + ranges[i - 1]);
        }
        return new SparseBitSet(ranges);
    }

    private SparseBitSet(int[] ranges) {
        this.ranges = ranges;
    }

    private static int[] intArrayToRanges(int[] members) {
        int nMembers = members.length;
        if (nMembers == 0) {
            return new int[0];
        }
        Arrays.sort(members);
        int nRuns = 1;
        for (int i = 1; i < nMembers; ++i) {
            int current = members[i];
            int last = members[i - 1];
            if (current == last || current == last + 1) continue;
            ++nRuns;
        }
        int[] ranges = new int[nRuns * 2];
        ranges[0] = members[0];
        int k = 0;
        int i = 1;
        while (k + 2 < ranges.length) {
            int current = members[i];
            int last = members[i - 1];
            if (current != last && current != last + 1) {
                ranges[++k] = last + 1;
                ranges[++k] = current;
            }
            ++i;
        }
        ranges[++k] = members[nMembers - 1] + 1;
        return ranges;
    }

    public boolean contains(int bit) {
        return (Arrays.binarySearch(this.ranges, bit) & 1) == 0;
    }

    public int minSetBit() {
        return this.ranges.length >= 0 ? this.ranges[0] : Integer.MIN_VALUE;
    }

    public boolean isEmpty() {
        return this.ranges.length == 0;
    }

    public SparseBitSet union(SparseBitSet other) {
        int[] q = this.ranges;
        int[] r = other.ranges;
        int m = q.length;
        int n = r.length;
        if (m == 0) {
            return other;
        }
        if (n == 0) {
            return this;
        }
        int[] out = new int[m + n];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < m && j < n) {
            int a0 = q[i];
            int a1 = q[i + 1];
            int b0 = r[j];
            int b1 = r[j + 1];
            if (a1 < b0) {
                out[k++] = a0;
                out[k++] = a1;
                i += 2;
                continue;
            }
            if (b1 < a0) {
                out[k++] = b0;
                out[k++] = b1;
                j += 2;
                continue;
            }
            int start = Math.min(a0, b0);
            int end = Math.max(a1, b1);
            i += 2;
            j += 2;
            while (i < m || j < n) {
                if (i < m && q[i] <= end) {
                    end = Math.max(end, q[i + 1]);
                    i += 2;
                    continue;
                }
                if (j >= n || r[j] > end) break;
                end = Math.max(end, r[j + 1]);
                j += 2;
            }
            out[k++] = start;
            out[k++] = end;
        }
        if (i < m) {
            System.arraycopy(q, i, out, k, m - i);
            k += m - i;
        } else if (j < n) {
            System.arraycopy(r, j, out, k, n - j);
            k += n - j;
        }
        if (k != out.length) {
            int[] clipped = new int[k];
            System.arraycopy(out, 0, clipped, 0, k);
            out = clipped;
        }
        return new SparseBitSet(out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.ranges.length; ++i) {
            if ((i & 1) != 0 && this.ranges[i] == this.ranges[i - 1] + 1) continue;
            if (i != 0) {
                sb.append((i & 1) == 0 ? (char)' ' : '-');
            }
            sb.append("0x").append(Integer.toString(this.ranges[i] - (i & 1), 16));
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SparseBitSet)) {
            return false;
        }
        return Arrays.equals(this.ranges, ((SparseBitSet)o).ranges);
    }

    public int hashCode() {
        int hc = 0;
        int n = Math.min(16, this.ranges.length);
        for (int i = 0; i < n; ++i) {
            hc = (hc << 2) + this.ranges[i];
        }
        return hc;
    }

    private static int[] primitiveArrayToInts(byte[] bytes) {
        int[] ints = new int[bytes.length];
        int i = bytes.length;
        while (--i >= 0) {
            ints[i] = bytes[i];
        }
        return ints;
    }

    private static int[] primitiveArrayToInts(char[] chars) {
        int[] ints = new int[chars.length];
        int i = chars.length;
        while (--i >= 0) {
            ints[i] = chars[i];
        }
        return ints;
    }

    private static int[] primitiveArrayToInts(short[] shorts) {
        int[] ints = new int[shorts.length];
        int i = shorts.length;
        while (--i >= 0) {
            ints[i] = shorts[i];
        }
        return ints;
    }
}

