/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import javax.servlet.http.HttpServletResponse;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.URLFactoryService;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class DefaultRequestHandler
extends WebRequestHandler {
    private final UserPortalConfigService configService;
    private final URLFactoryService urlFactory;

    public DefaultRequestHandler(UserPortalConfigService configService, URLFactoryService urlFactory) {
        this.configService = configService;
        this.urlFactory = urlFactory;
    }

    public String getHandlerName() {
        return "default";
    }

    public boolean execute(ControllerContext context) throws Exception {
        String defaultPortal = this.configService.getDefaultPortal();
        PortalURLContext urlContext = new PortalURLContext(context, SiteKey.portal((String)defaultPortal));
        NodeURL url = (NodeURL)this.urlFactory.newURL(NodeURL.TYPE, (URLContext)urlContext);
        String s = url.setResource(new NavigationResource(SiteType.PORTAL, defaultPortal, "")).toString();
        HttpServletResponse resp = context.getResponse();
        resp.sendRedirect(resp.encodeRedirectURL(s));
        return true;
    }

    protected boolean getRequiresLifeCycle() {
        return false;
    }
}

