/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.application.StandaloneAppRequestContext;
import org.exoplatform.portal.application.StandaloneApplication;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.Application;

public class StandaloneAppRequestHandler
extends PortalRequestHandler {
    private String webuiConfigPath;

    public StandaloneAppRequestHandler(InitParams params) {
        ValueParam valueParam = params.getValueParam("webui.configuration");
        if (valueParam != null) {
            this.webuiConfigPath = valueParam.getValue();
        }
    }

    public String getHandlerName() {
        return "standalone";
    }

    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        StandaloneApplication standaloneApplication = new StandaloneApplication(sConfig);
        standaloneApplication.setWebUIConfigPath(this.webuiConfigPath);
        standaloneApplication.onInit();
        controller.addApplication((Application)standaloneApplication);
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        HttpServletRequest req = controllerContext.getRequest();
        HttpServletResponse res = controllerContext.getResponse();
        log.debug((Object)("Session ID = " + req.getSession().getId()));
        res.setHeader("Cache-Control", "no-cache");
        String requestPath = controllerContext.getParameter(REQUEST_PATH);
        StandaloneApplication app = (StandaloneApplication)controllerContext.getController().getApplication("StandaloneApplication");
        StandaloneAppRequestContext context = new StandaloneAppRequestContext(app, controllerContext, requestPath);
        this.processRequest(context, app);
        return true;
    }
}

