/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.common.ResourceBundleUtil;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/profile/UIProfileUserSearch.gtmpl", events={@EventConfig(listeners={SearchActionListener.class})})
public class UIProfileUserSearch
extends UIForm {
    public static final String SEARCH = "Search";
    public static final String USER_CONTACT = "name";
    public static final String REG_FOR_SPLIT = "[^_A-Za-z0-9-.\\s[\\n]]";
    static final String RIGHT_INPUT_PATTERN = "^[\\p{L}][\\p{L}._\\- \\d]+$";
    public static final String POSITION_REGEX_EXPRESSION = "^\\p{L}[\\p{L}\\d._,\\s]+\\p{L}$";
    static final String PREFIX_ADDED_FOR_CHECK = "PrefixAddedForCheck";
    private static final char EMPTY_CHARACTER = '\u0000';
    private static final String ALL_FILTER = "All";
    private static final String HTML_ATTRIBUTE_TITLE = "title";
    private List<Identity> identityList = null;
    private String rawSearchConditional;
    String selectedChar = null;
    ProfileFilter profileFilter = null;
    String typeOfRelation = null;
    String spaceURL = null;
    private boolean isNewSearch;
    long identitiesCount;
    private boolean hasPeopleTab;
    private boolean hasConnectionLink;
    private int peopleNum;

    public boolean isHasPeopleTab() {
        return this.hasPeopleTab;
    }

    public void setHasPeopleTab(boolean hasPeopleTab) {
        this.hasPeopleTab = hasPeopleTab;
    }

    public boolean isHasConnectionLink() {
        return this.hasConnectionLink;
    }

    public void setHasConnectionLink(boolean hasConnectionLink) {
        this.hasConnectionLink = hasConnectionLink;
    }

    public int getPeopleNum() {
        return this.peopleNum;
    }

    public void setPeopleNum(int peopleNum) {
        this.peopleNum = peopleNum;
    }

    public void setIdentityList(List<Identity> identityList) throws Exception {
        if (identityList.contains(Utils.getViewerIdentity())) {
            identityList.remove(Utils.getViewerIdentity());
        }
        this.identityList = identityList;
    }

    public final List<Identity> getIdentityList() {
        return this.identityList;
    }

    public String getRawSearchConditional() {
        return this.rawSearchConditional;
    }

    public void setRawSearchConditional(String rawSearchConditional) {
        this.rawSearchConditional = rawSearchConditional;
    }

    public final String getSelectedChar() {
        return this.selectedChar;
    }

    public final void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public String getTypeOfRelation() {
        return this.typeOfRelation;
    }

    public void setTypeOfRelation(String typeOfRelation) {
        this.typeOfRelation = typeOfRelation;
    }

    public String getSpaceURL() {
        return this.spaceURL;
    }

    public void setSpaceURL(String spaceURL) {
        this.spaceURL = spaceURL;
    }

    protected String getCurrentUserName() {
        return RequestContext.getCurrentInstance().getRemoteUser();
    }

    protected String getRestContextName() {
        return PortalContainer.getCurrentRestContextName();
    }

    public final ProfileFilter getProfileFilter() {
        return this.profileFilter;
    }

    public final void setProfileFilter(ProfileFilter profileFilter) {
        this.profileFilter = profileFilter;
    }

    public UIProfileUserSearch() throws Exception {
        ResourceBundle resourceBudle = PortalRequestContext.getCurrentInstance().getApplicationResourceBundle();
        String defaultName = resourceBudle.getString("UIProfileUserSearch.label.Name");
        String defaultPos = resourceBudle.getString("UIProfileUserSearch.label.Position");
        String defaultSkills = resourceBudle.getString("UIProfileUserSearch.label.Skills");
        UIFormStringInput search = new UIFormStringInput(SEARCH, USER_CONTACT, defaultName);
        search.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, defaultName);
        this.addUIFormInput((UIFormInput)search);
        UIFormStringInput position = new UIFormStringInput("position", "position", defaultPos);
        position.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, defaultPos);
        this.addUIFormInput((UIFormInput)position);
        UIFormStringInput skills = new UIFormStringInput("skills", "skills", defaultSkills);
        skills.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, defaultSkills);
        this.addUIFormInput((UIFormInput)skills);
        this.profileFilter = new ProfileFilter();
        this.setHasPeopleTab(false);
        this.setSelectedChar(ALL_FILTER);
    }

    protected void resetUIComponentValues() {
        ResourceBundle resourceBudle = PortalRequestContext.getCurrentInstance().getApplicationResourceBundle();
        if (this.profileFilter != null && this.profileFilter.getName() != null && this.profileFilter.getName().equals("")) {
            UIFormStringInput uiName = (UIFormStringInput)this.getChildById(SEARCH);
            String defaultName = resourceBudle.getString("UIProfileUserSearch.label.Name");
            uiName.setValue((Object)defaultName);
        }
        if (this.profileFilter != null && this.profileFilter.getPosition() != null && this.profileFilter.getPosition().equals("")) {
            UIFormStringInput uiPos = (UIFormStringInput)this.getChildById("position");
            String defaultPos = resourceBudle.getString("UIProfileUserSearch.label.Position");
            uiPos.setValue((Object)defaultPos);
        }
        if (this.profileFilter != null && this.profileFilter.getSkills() != null && this.profileFilter.getSkills().equals("")) {
            UIFormStringInput uiSkills = (UIFormStringInput)this.getChildById("skills");
            String defaultSkills = resourceBudle.getString("UIProfileUserSearch.label.Skills");
            uiSkills.setValue((Object)defaultSkills);
        }
    }

    public String getSelectedNode() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String currentPath = pcontext.getControllerContext().getParameter(QualifiedName.parse((String)"gtn:path"));
        if (currentPath.split("/").length >= 2) {
            return currentPath.split("/")[1];
        }
        return currentPath;
    }

    public List<Identity> getIdentitiesBySkills(List<Identity> identities) {
        ArrayList<Identity> identityLst = new ArrayList<Identity>();
        String prof = null;
        String skill = this.getProfileFilter().getSkills().trim().toLowerCase();
        if (identities.size() == 0) {
            return identityLst;
        }
        for (Identity id : identities) {
            Profile profile = id.getProfile();
            ArrayList experiences = (ArrayList)profile.getProperty("experiences");
            if (experiences == null) continue;
            block1: for (HashMap exp : experiences) {
                String[] items;
                prof = (String)exp.get("skills");
                if (prof == null) continue;
                Pattern p = Pattern.compile(REG_FOR_SPLIT);
                for (String item : items = p.split(prof)) {
                    if (!item.toLowerCase().matches(skill)) continue;
                    identityLst.add(id);
                    continue block1;
                }
            }
        }
        return UIProfileUserSearch.GetUniqueIdentities(identityLst);
    }

    protected String getPeopleFoundLabel() {
        String labelArg = "UIProfileUserSearch.label.FoundContactFilter";
        if (this.getPeopleNum() > 1) {
            labelArg = "UIProfileUserSearch.label.FoundContactsFilter";
        }
        String searchCondition = this.getSelectedChar();
        if (this.selectedChar == null) {
            labelArg = "UIProfileUserSearch.label.FoundContactSearch";
            if (this.getPeopleNum() > 1) {
                labelArg = "UIProfileUserSearch.label.FoundContactsSearch";
            }
            searchCondition = this.getRawSearchConditional();
        }
        if (ALL_FILTER.equals(searchCondition)) {
            searchCondition = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle().getString("UIProfileUserSearch.label.SearchAll");
        }
        return ResourceBundleUtil.replaceArguments((String)WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle().getString(labelArg), (String[])new String[]{Integer.toString(this.getPeopleNum())});
    }

    private static Collection<Identity> Union(Collection<Identity> identities1, Collection<Identity> identities2) {
        HashSet<Identity> identities = new HashSet<Identity>(identities1);
        identities.addAll(new HashSet<Identity>(identities2));
        return new ArrayList<Identity>(identities);
    }

    private static ArrayList<Identity> GetUniqueIdentities(Collection<Identity> identities) {
        return (ArrayList)UIProfileUserSearch.Union(identities, identities);
    }

    public final boolean isNewSearch() {
        return this.isNewSearch;
    }

    public final void setNewSearch(boolean isNewSearch) {
        this.isNewSearch = isNewSearch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIProfileUserSearch> {
        public final void execute(Event<UIProfileUserSearch> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UIProfileUserSearch uiSearch = (UIProfileUserSearch)((Object)event.getSource());
            String charSearch = ctx.getRequestParameter("objectId");
            ProfileFilter filter = new ProfileFilter();
            ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
            excludedIdentityList.add(Utils.getViewerIdentity());
            filter.setExcludedIdentityList(excludedIdentityList);
            uiSearch.invokeSetBindingBean(filter);
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            String defaultNameVal = resApp.getString(uiSearch.getId() + ".label.Name");
            String defaultPosVal = resApp.getString(uiSearch.getId() + ".label.Position");
            String defaultSkillsVal = resApp.getString(uiSearch.getId() + ".label.Skills");
            try {
                uiSearch.setSelectedChar(charSearch);
                if (charSearch != null) {
                    ((UIFormStringInput)uiSearch.getChildById(UIProfileUserSearch.SEARCH)).setValue((Object)defaultNameVal);
                    ((UIFormStringInput)uiSearch.getChildById("position")).setValue((Object)defaultPosVal);
                    ((UIFormStringInput)uiSearch.getChildById("skills")).setValue((Object)defaultSkillsVal);
                    filter.setName(charSearch);
                    filter.setPosition("");
                    filter.setSkills("");
                    filter.setFirstCharacterOfName(charSearch.toCharArray()[0]);
                    if (UIProfileUserSearch.ALL_FILTER.equals(charSearch)) {
                        filter.setFirstCharacterOfName('\u0000');
                        filter.setName("");
                    }
                    uiSearch.setRawSearchConditional("");
                } else {
                    uiSearch.setSelectedChar(null);
                    StringBuffer rawSearchMessageStringBuffer = new StringBuffer();
                    if (filter.getName() == null || filter.getName().equals(defaultNameVal)) {
                        filter.setName("");
                    } else {
                        rawSearchMessageStringBuffer.append(defaultNameVal + ":" + filter.getName());
                    }
                    if (filter.getPosition() == null || filter.getPosition().equals(defaultPosVal)) {
                        filter.setPosition("");
                    } else {
                        rawSearchMessageStringBuffer.append((rawSearchMessageStringBuffer.length() > 0 ? " " : "") + defaultPosVal + ":" + filter.getPosition());
                    }
                    if (filter.getSkills() == null || filter.getSkills().equals(defaultSkillsVal)) {
                        filter.setSkills("");
                    } else {
                        rawSearchMessageStringBuffer.append((rawSearchMessageStringBuffer.length() > 0 ? " " : "") + defaultSkillsVal + ":" + filter.getSkills());
                    }
                    if (rawSearchMessageStringBuffer.length() > 0) {
                        uiSearch.setRawSearchConditional(rawSearchMessageStringBuffer.toString());
                        if (!this.isValidInput(filter)) {
                            filter.setName("@");
                            filter.setCompany("");
                            filter.setSkills("");
                            filter.setPosition("");
                        }
                    } else {
                        uiSearch.setSelectedChar(UIProfileUserSearch.ALL_FILTER);
                        uiSearch.setRawSearchConditional(UIProfileUserSearch.ALL_FILTER);
                        filter.setFirstCharacterOfName('\u0000');
                        filter.setName("");
                        filter.setCompany("");
                        filter.setSkills("");
                        filter.setPosition("");
                    }
                }
                uiSearch.setProfileFilter(filter);
                uiSearch.setNewSearch(true);
            }
            catch (Exception e) {
                uiSearch.setIdentityList(new ArrayList<Identity>());
            }
            Event searchEvent = uiSearch.getParent().createEvent(UIProfileUserSearch.SEARCH, Event.Phase.DECODE, ctx);
            if (searchEvent != null) {
                searchEvent.broadcast();
            }
        }

        private boolean isValidInput(ProfileFilter input) {
            String contactName = input.getName();
            String position = input.getPosition();
            String skills = input.getSkills();
            String company = input.getCompany();
            String contactNameForCheck = null;
            if (contactName != null) {
                contactNameForCheck = contactName.replaceAll("[/*%]", "").trim();
                contactNameForCheck = UIProfileUserSearch.PREFIX_ADDED_FOR_CHECK + contactNameForCheck;
                if (!contactNameForCheck.matches(UIProfileUserSearch.RIGHT_INPUT_PATTERN)) {
                    return false;
                }
            }
            String positionForCheck = null;
            if (contactName != null) {
                positionForCheck = position.replaceAll("[/*%]", "").trim();
                positionForCheck = UIProfileUserSearch.PREFIX_ADDED_FOR_CHECK + positionForCheck;
                if (!positionForCheck.matches(UIProfileUserSearch.RIGHT_INPUT_PATTERN)) {
                    return false;
                }
            }
            String skillsForCheck = null;
            if (contactName != null) {
                skillsForCheck = skills.replaceAll("[/*%]", "").trim();
                skillsForCheck = UIProfileUserSearch.PREFIX_ADDED_FOR_CHECK + skillsForCheck;
                if (!skillsForCheck.matches(UIProfileUserSearch.RIGHT_INPUT_PATTERN)) {
                    return false;
                }
            }
            String companyForCheck = null;
            if (contactName != null) {
                companyForCheck = company.replaceAll("[/*%]", "").trim();
                companyForCheck = UIProfileUserSearch.PREFIX_ADDED_FOR_CHECK + companyForCheck;
                if (!companyForCheck.matches(UIProfileUserSearch.RIGHT_INPUT_PATTERN)) {
                    return false;
                }
            }
            return true;
        }
    }
}

