/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Marshaller;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class FD
extends Protocol {
    Address local_addr = null;
    long timeout = 3000L;
    long last_ack = System.currentTimeMillis();
    int num_tries = 0;
    int max_tries = 2;
    protected final Lock lock = new ReentrantLock();
    Address ping_dest = null;
    final List<Address> members = new ArrayList<Address>();
    final List<Address> pingable_mbrs = new ArrayList<Address>();
    final Map<Address, Integer> invalid_pingers = new HashMap<Address, Integer>(7);
    boolean shun = true;
    TimeScheduler timer = null;
    private Future monitor_future = null;
    protected int num_heartbeats = 0;
    protected int num_suspect_events = 0;
    protected final Broadcaster bcast_task = new Broadcaster();
    static final String name = "FD";
    final BoundedList<Address> suspect_history = new BoundedList(20);

    @Override
    public String getName() {
        return name;
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "null";
    }

    public String getPingableMembers() {
        return this.pingable_mbrs != null ? this.pingable_mbrs.toString() : "null";
    }

    public String getPingDest() {
        return this.ping_dest != null ? this.ping_dest.toString() : "null";
    }

    public int getNumberOfHeartbeatsSent() {
        return this.num_heartbeats;
    }

    public int getNumSuspectEventsGenerated() {
        return this.num_suspect_events;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getMaxTries() {
        return this.max_tries;
    }

    public void setMaxTries(int max_tries) {
        this.max_tries = max_tries;
    }

    public int getCurrentNumTries() {
        return this.num_tries;
    }

    public boolean isShun() {
        return this.shun;
    }

    public void setShun(boolean flag) {
        this.shun = flag;
    }

    public String printSuspectHistory() {
        StringBuilder sb = new StringBuilder();
        for (Address addr : this.suspect_history) {
            sb.append(new Date()).append(": ").append(addr).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("max_tries")) != null) {
            this.max_tries = Integer.parseInt(str);
            props.remove("max_tries");
        }
        if ((str = props.getProperty("shun")) != null) {
            this.shun = Boolean.valueOf(str);
            props.remove("shun");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    @Override
    public void resetStats() {
        this.num_suspect_events = 0;
        this.num_heartbeats = 0;
        this.suspect_history.clear();
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.stopMonitor();
        }
        finally {
            this.lock.unlock();
        }
    }

    private Address getPingDest(List<Address> mbrs) {
        Address retval = null;
        if (mbrs == null || mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        for (int i = 0; i < mbrs.size(); ++i) {
            Address tmp = mbrs.get(i);
            if (!this.local_addr.equals(tmp)) continue;
            if (i + 1 >= mbrs.size()) {
                retval = mbrs.get(0);
                break;
            }
            retval = mbrs.get(i + 1);
            break;
        }
        return retval;
    }

    private void startMonitor() {
        if (this.monitor_future == null || this.monitor_future.isDone()) {
            this.last_ack = System.currentTimeMillis();
            this.monitor_future = this.timer.scheduleWithFixedDelay(new Monitor(), this.timeout, this.timeout, TimeUnit.MILLISECONDS);
            this.num_tries = 0;
        }
    }

    private void stopMonitor() {
        if (this.monitor_future != null) {
            this.monitor_future.cancel(true);
            this.monitor_future = null;
        }
    }

    private void restartMonitor() {
        block4: {
            boolean restart_monitor;
            Address tmp_dest = this.getPingDest(this.pingable_mbrs);
            boolean bl = restart_monitor = tmp_dest == null || this.ping_dest == null || !this.ping_dest.equals(tmp_dest);
            if (restart_monitor) {
                this.ping_dest = tmp_dest;
                this.stopMonitor();
                if (this.ping_dest != null) {
                    try {
                        this.startMonitor();
                    }
                    catch (Exception ex) {
                        if (!this.log.isWarnEnabled()) break block4;
                        this.log.warn((Object)("exception when calling startMonitor(): " + ex));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                FdHeader hdr = (FdHeader)msg.getHeader(name);
                if (hdr == null) {
                    this.updateTimestamp(msg.getSrc());
                    break;
                }
                switch (hdr.type) {
                    case 0: {
                        Address hb_sender = msg.getSrc();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("received are-you-alive from " + hb_sender + ", sending response"));
                        }
                        this.sendHeartbeatResponse(hb_sender);
                        if (!this.shun) break;
                        this.shunInvalidHeartbeatSender(hb_sender);
                        break;
                    }
                    case 1: {
                        this.updateTimestamp(hdr.from);
                        break;
                    }
                    case 2: {
                        if (hdr.mbrs == null) break;
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("[SUSPECT] suspect hdr is " + hdr));
                        }
                        for (int i = 0; i < hdr.mbrs.size(); ++i) {
                            Address m = hdr.mbrs.elementAt(i);
                            if (this.local_addr != null && m.equals(this.local_addr)) {
                                if (this.log.isWarnEnabled()) {
                                    this.log.warn((Object)("I was suspected by " + msg.getSrc() + "; ignoring the SUSPECT " + "message and sending back a HEARTBEAT_ACK"));
                                }
                                this.sendHeartbeatResponse(msg.getSrc());
                                continue;
                            }
                            this.lock.lock();
                            try {
                                this.pingable_mbrs.remove(m);
                                this.restartMonitor();
                            }
                            finally {
                                this.lock.unlock();
                            }
                            this.up_prot.up(new Event(9, m));
                            this.down_prot.down(new Event(9, m));
                        }
                        break;
                    }
                    case 3: {
                        if (!this.shun) break;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"[NOT_MEMBER] I'm being shunned; exiting");
                        }
                        this.up_prot.up(new Event(46));
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.down_prot.down(evt);
                this.lock.lock();
                try {
                    View v = (View)evt.getArg();
                    this.members.clear();
                    this.members.addAll(v.getMembers());
                    this.bcast_task.adjustSuspectedMembers(this.members);
                    this.pingable_mbrs.clear();
                    this.pingable_mbrs.addAll(this.members);
                    this.restartMonitor();
                }
                finally {
                    this.lock.unlock();
                }
                return null;
            }
            case 51: {
                this.unsuspect((Address)evt.getArg());
                return this.down_prot.down(evt);
            }
        }
        return this.down_prot.down(evt);
    }

    private void sendHeartbeatResponse(Address dest) {
        Message hb_ack = new Message(dest, null, null);
        hb_ack.setFlag((byte)1);
        FdHeader tmp_hdr = new FdHeader(1);
        tmp_hdr.from = this.local_addr;
        hb_ack.putHeader(name, tmp_hdr);
        this.down_prot.down(new Event(1, hb_ack));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsuspect(Address mbr) {
        this.lock.lock();
        try {
            this.bcast_task.removeSuspectedMember(mbr);
            this.pingable_mbrs.clear();
            this.pingable_mbrs.addAll(this.members);
            this.pingable_mbrs.removeAll(this.bcast_task.getSuspectedMembers());
            this.restartMonitor();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimestamp(Address sender) {
        if (this.ping_dest != null && sender != null && this.ping_dest.equals(sender)) {
            long tmp = System.currentTimeMillis();
            this.lock.lock();
            try {
                this.last_ack = tmp;
                this.num_tries = 0;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shunInvalidHeartbeatSender(Address hb_sender) {
        int num_pings = 0;
        Message shun_msg = null;
        this.lock.lock();
        try {
            if (hb_sender != null && this.members != null && !this.members.contains(hb_sender)) {
                if (this.invalid_pingers.containsKey(hb_sender)) {
                    num_pings = this.invalid_pingers.get(hb_sender);
                    if (num_pings >= this.max_tries) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)(hb_sender + " is not in " + this.members + " ! Shunning it"));
                        }
                        shun_msg = new Message(hb_sender, null, null);
                        shun_msg.setFlag((byte)1);
                        shun_msg.putHeader(name, new FdHeader(3));
                        this.invalid_pingers.remove(hb_sender);
                    } else {
                        this.invalid_pingers.put(hb_sender, new Integer(++num_pings));
                    }
                } else {
                    this.invalid_pingers.put(hb_sender, new Integer(++num_pings));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (shun_msg != null) {
            this.down_prot.down(new Event(1, shun_msg));
        }
    }

    protected final class BroadcastTask
    implements Runnable {
        private final Vector<Address> suspected_members = new Vector();

        BroadcastTask(Vector<Address> suspected_members) {
            this.suspected_members.addAll(suspected_members);
        }

        public void stop() {
            this.suspected_members.clear();
            if (FD.this.log.isTraceEnabled()) {
                FD.this.log.trace((Object)"BroadcastTask stopped");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FdHeader hdr;
            Vector<Address> vector = this.suspected_members;
            synchronized (vector) {
                if (this.suspected_members.isEmpty()) {
                    this.stop();
                    return;
                }
                hdr = new FdHeader(2);
                hdr.mbrs = new Vector<Address>(this.suspected_members);
                hdr.from = FD.this.local_addr;
            }
            Message suspect_msg = new Message();
            suspect_msg.setFlag((byte)1);
            suspect_msg.putHeader(FD.name, hdr);
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug((Object)("broadcasting SUSPECT message [suspected_mbrs=" + this.suspected_members + "] to group"));
            }
            FD.this.down_prot.down(new Event(1, suspect_msg));
        }

        public void addSuspectedMember(Address suspect) {
            if (suspect != null && !this.suspected_members.contains(suspect)) {
                this.suspected_members.add(suspect);
            }
        }
    }

    protected final class Broadcaster {
        final Vector<Address> suspected_mbrs = new Vector(7);
        final Lock bcast_lock = new ReentrantLock();
        Future bcast_future = null;
        BroadcastTask task;

        protected Broadcaster() {
        }

        Vector getSuspectedMembers() {
            return this.suspected_mbrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startBroadcastTask(Address suspect) {
            this.bcast_lock.lock();
            try {
                if (this.bcast_future == null || this.bcast_future.isDone()) {
                    this.task = new BroadcastTask(this.suspected_mbrs);
                    this.task.addSuspectedMember(suspect);
                    this.bcast_future = FD.this.timer.scheduleWithFixedDelay(this.task, 0L, FD.this.timeout, TimeUnit.MILLISECONDS);
                    if (FD.this.log.isTraceEnabled()) {
                        FD.this.log.trace((Object)"BroadcastTask started");
                    }
                } else {
                    this.task.addSuspectedMember(suspect);
                }
            }
            finally {
                this.bcast_lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopBroadcastTask() {
            this.bcast_lock.lock();
            try {
                if (this.bcast_future != null) {
                    this.bcast_future.cancel(true);
                    this.bcast_future = null;
                    this.task = null;
                }
            }
            finally {
                this.bcast_lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            if (!FD.this.members.contains(mbr)) {
                return;
            }
            Vector<Address> vector = this.suspected_mbrs;
            synchronized (vector) {
                if (!this.suspected_mbrs.contains(mbr)) {
                    this.suspected_mbrs.addElement(mbr);
                    this.startBroadcastTask(mbr);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug((Object)("member is " + suspected_mbr));
            }
            Vector<Address> vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeElement(suspected_mbr);
                if (this.suspected_mbrs.isEmpty()) {
                    this.stopBroadcastTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void adjustSuspectedMembers(List new_mbrship) {
            if (new_mbrship == null || new_mbrship.isEmpty()) {
                return;
            }
            Vector<Address> vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.retainAll(new_mbrship);
                if (this.suspected_mbrs.isEmpty()) {
                    this.stopBroadcastTask();
                }
            }
        }
    }

    protected class Monitor
    implements Runnable {
        protected Monitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Address dest = null;
            FD.this.lock.lock();
            try {
                if (FD.this.ping_dest == null) {
                    if (FD.this.log.isWarnEnabled()) {
                        FD.this.log.warn((Object)("ping_dest is null: members=" + FD.this.members + ", pingable_mbrs=" + FD.this.pingable_mbrs + ", local_addr=" + FD.this.local_addr));
                    }
                    return;
                }
                dest = FD.this.ping_dest;
            }
            finally {
                FD.this.lock.unlock();
            }
            Message hb_req = new Message(dest, null, null);
            hb_req.setFlag((byte)1);
            hb_req.putHeader(FD.name, new FdHeader(0));
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug((Object)("sending are-you-alive msg to " + dest + " (own address=" + FD.this.local_addr + ')'));
            }
            FD.this.down_prot.down(new Event(1, hb_req));
            ++FD.this.num_heartbeats;
            long not_heard_from = System.currentTimeMillis() - FD.this.last_ack;
            if (not_heard_from > FD.this.timeout + 500L) {
                if (FD.this.num_tries >= FD.this.max_tries) {
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug((Object)("[" + FD.this.local_addr + "]: received no heartbeat ack from " + dest + " for " + (FD.this.num_tries + 1) + " times (" + (long)(FD.this.num_tries + 1) * FD.this.timeout + " milliseconds), suspecting it"));
                    }
                    FD.this.bcast_task.addSuspectedMember(dest);
                    FD.this.num_tries = 0;
                    if (FD.this.stats) {
                        ++FD.this.num_suspect_events;
                        FD.this.suspect_history.add(dest);
                    }
                } else {
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug((Object)("heartbeat missing from " + dest + " (number=" + FD.this.num_tries + ')'));
                    }
                    ++FD.this.num_tries;
                }
            }
        }
    }

    public static class FdHeader
    extends Header
    implements Streamable {
        public static final byte HEARTBEAT = 0;
        public static final byte HEARTBEAT_ACK = 1;
        public static final byte SUSPECT = 2;
        public static final byte NOT_MEMBER = 3;
        byte type = 0;
        Vector<Address> mbrs = null;
        Address from = null;
        private static final long serialVersionUID = -6387039473828820899L;

        public FdHeader() {
        }

        public FdHeader(byte type) {
            this.type = type;
        }

        public FdHeader(byte type, Vector<Address> mbrs, Address from) {
            this(type);
            this.mbrs = mbrs;
            this.from = from;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 0: {
                    return "heartbeat";
                }
                case 1: {
                    return "heartbeat ack";
                }
                case 2: {
                    return "SUSPECT (suspected_mbrs=" + this.mbrs + ", from=" + this.from + ")";
                }
                case 3: {
                    return "NOT_MEMBER";
                }
            }
            return "unknown type (" + this.type + ")";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            if (this.mbrs == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeInt(this.mbrs.size());
                for (Address addr : this.mbrs) {
                    Marshaller.write(addr, out);
                }
            }
            Marshaller.write(this.from, out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            boolean mbrs_not_null = in.readBoolean();
            if (mbrs_not_null) {
                int len = in.readInt();
                this.mbrs = new Vector(11);
                for (int i = 0; i < len; ++i) {
                    Address addr = (Address)Marshaller.read(in);
                    this.mbrs.add(addr);
                }
            }
            this.from = (Address)Marshaller.read(in);
        }

        @Override
        public int size() {
            int retval = 1;
            retval = (int)((long)retval + Util.size(this.mbrs));
            return retval += Util.size(this.from);
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            Util.writeAddresses(this.mbrs, out);
            Util.writeAddress(this.from, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.mbrs = (Vector)Util.readAddresses(in, Vector.class);
            this.from = Util.readAddress(in);
        }
    }
}

