/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class InterruptTest
extends TestCase {
    static final long TIMEOUT = 3000L;
    static final int SLEEP = 1;
    static final int WAIT = 2;
    static final int READ = 3;
    static final int SOCKET_READ = 4;

    public InterruptTest(String name) {
        super(name);
    }

    String modeToString(int m) {
        switch (m) {
            case 1: {
                return "SLEEP";
            }
            case 2: {
                return "WAIT";
            }
            case 3: {
                return "READ";
            }
            case 4: {
                return "SOCKET_READ";
            }
        }
        return "<unknown>";
    }

    public void testSleepInterrupt() {
        SleeperThread thread = new SleeperThread(1);
        this.runTest(thread);
    }

    public void testWaitInterrupt() {
        SleeperThread thread = new SleeperThread(2);
        this.runTest(thread);
    }

    void runTest(SleeperThread thread) {
        System.out.println();
        System.out.println("InterruptTest.runTest(" + this.modeToString(thread.getMode()) + "): starting other thread");
        thread.start();
        System.out.println("InterruptTest.runTest(" + this.modeToString(thread.getMode()) + "): starting other thread -- done");
        System.out.println("InterruptTest.runTest(" + this.modeToString(thread.getMode()) + "): sleeping for " + 3000L + " msecs");
        this.sleep(3000L);
        System.out.println("InterruptTest.runTest(" + this.modeToString(thread.getMode()) + "): sleeping -- done");
        System.out.println("InterruptTest.runTest(" + this.modeToString(thread.getMode()) + "): interrupting other thread");
        thread.interrupt();
        System.out.println("InterruptTest.runTest(" + this.modeToString(thread.getMode()) + "): interrupting other thread -- done");
        System.out.println("InterruptTest.runTest(" + this.modeToString(thread.getMode()) + "): joining other thread (timeout=" + 3000L + " msecs");
        try {
            thread.join(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("InterruptTest.runTest(" + this.modeToString(thread.getMode()) + "): joining other thread -- done");
        System.out.println("InterruptTest.runTest(" + this.modeToString(thread.getMode()) + "): thread.isAlive()=" + thread.isAlive());
        InterruptTest.assertTrue((!thread.isAlive() ? 1 : 0) != 0);
    }

    void sleep(long msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (Exception ex) {
            System.err.println("InterruptTest.sleep(): " + ex);
        }
    }

    public static Test suite() {
        TestSuite s = new TestSuite(InterruptTest.class);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)InterruptTest.suite());
    }

    class SleeperThread
    extends Thread {
        int mode;
        DatagramSocket sock = null;

        SleeperThread(int mode) {
            this.mode = mode;
        }

        public int getMode() {
            return this.mode;
        }

        @Override
        public void run() {
            switch (this.mode) {
                case 1: {
                    this.runSleep();
                    break;
                }
                case 2: {
                    this.runWait();
                    break;
                }
                case 3: {
                    this.runRead();
                    break;
                }
                case 4: {
                    this.runSocketRead();
                    break;
                }
            }
        }

        void runSleep() {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                System.err.println("InterruptTest.SleeperThread.runSleep(): " + ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runWait() {
            Object mutex;
            Object object = mutex = new Object();
            synchronized (object) {
                try {
                    mutex.wait();
                }
                catch (InterruptedException ex) {
                    System.err.println("InterruptTest.SleeperThread.runWait(): " + ex);
                }
            }
        }

        void runRead() {
            try {
                System.in.read();
            }
            catch (Exception ex) {
                System.err.println("InterruptTest.SleeperThread.runRead(): " + ex);
            }
        }

        void runSocketRead() {
            byte[] buf = new byte[2];
            try {
                this.sock = new DatagramSocket(12345, InetAddress.getLocalHost());
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                this.sock.receive(packet);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }
}

