/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.model.ProfileAttachment;
import org.exoplatform.social.portlet.profile.Utils;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/portal/webui/component/UIProfileNavigationPortlet.gtmpl")
public class UIProfileNavigationPortlet
extends UIPortletApplication {
    public String getSelectedNode() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String requestUrl = pcontext.getRequestURI();
        String[] split = requestUrl.split("/");
        if (split.length == 6) {
            return split[split.length - 2];
        }
        if (split.length == 7) {
            return split[split.length - 3];
        }
        return split[split.length - 1];
    }

    public boolean isMe() {
        RequestContext context = RequestContext.getCurrentInstance();
        String currentUserName = context.getRemoteUser();
        String currentViewer = URLUtils.getCurrentUser();
        if (currentViewer == null) {
            return true;
        }
        return currentUserName.equals(currentViewer);
    }

    protected String getImageSource() throws Exception {
        Identity currIdentity = Utils.getCurrentIdentity();
        Profile p = currIdentity.getProfile();
        ProfileAttachment att = (ProfileAttachment)p.getProperty("avatar");
        if (att != null) {
            return "/" + this.getPortalName() + "/rest/jcr/" + this.getRepository() + "/" + att.getWorkspace() + att.getDataPath() + "/?rnd=" + System.currentTimeMillis();
        }
        return null;
    }

    private String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }
}

