/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.profile;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.social.core.identity.model.ProfileAttachment;
import org.exoplatform.social.portlet.profile.UIAvatarUploadContent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;

@ComponentConfig(template="app:/groovy/portal/webui/component/UIAvatarUploadContent.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AbortActionListener.class})})
public class UIAvatarUploadContent
extends UIContainer {
    public static final String AVARTAR_PROPERTY = "avatar";
    private ProfileAttachment profileAttachment;
    private String imageSource;

    public UIAvatarUploadContent() {
    }

    public UIAvatarUploadContent(ProfileAttachment profileAttachment) throws Exception {
        this.profileAttachment = profileAttachment;
        this.setImageSource(profileAttachment.getImageBytes());
    }

    public ProfileAttachment getProfileAttachment() {
        return this.profileAttachment;
    }

    public void setProfileAttachment(ProfileAttachment profileAttachment) throws Exception {
        this.profileAttachment = profileAttachment;
        this.setImageSource(profileAttachment.getImageBytes());
    }

    private void setImageSource(byte[] imageBytes) throws Exception {
        if (imageBytes == null || imageBytes.length == 0) {
            return;
        }
        ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
        DownloadService downloadService = (DownloadService)this.getApplicationComponent(DownloadService.class);
        InputStreamDownloadResource downloadResource = new InputStreamDownloadResource((InputStream)byteImage, "image");
        downloadResource.setDownloadName(this.profileAttachment.getFileName());
        this.imageSource = downloadService.getDownloadLink(downloadService.addDownloadResource((DownloadResource)downloadResource));
    }

    public String getImageSource() {
        return this.imageSource;
    }

    public static void updateWorkingWorkSpace() {
        UIPortalApplication uiPortalApplication = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApplication.getChildById("UIWorkingWorkspace");
        PortalRequestContext pContext = Util.getPortalRequestContext();
        pContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        pContext.setFullRender(true);
    }
}

