/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.profile;

import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.portlet.profile.UIBasicInfoTitleBar;
import org.exoplatform.social.portlet.profile.UIProfileSection;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/portal/webui/component/UIBasicInfoSection.gtmpl", events={@EventConfig(listeners={UIProfileSection.EditActionListener.class}, phase=Event.Phase.DECODE)})
public class UIBasicInfoSection
extends UIProfileSection {
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String GENDER = "gender";
    public static final String GENDER_DEFAULT = "Gender";
    public static final String MALE = "male";
    public static final String FEMALE = "female";
    public static final String REGEX_EXPRESSION = "^\\p{L}[\\p{L}\\d._,\\s]+\\p{L}$";
    public static final String INVALID_CHAR_MESSAGE = "UIBasicInfoSection.msg.Invalid-char";

    public UIBasicInfoSection() throws Exception {
        this.addChild(UIBasicInfoTitleBar.class, null, null);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIRST_NAME, FIRST_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(ExpressionValidator.class, new Object[]{REGEX_EXPRESSION, INVALID_CHAR_MESSAGE}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(LAST_NAME, LAST_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(ExpressionValidator.class, new Object[]{REGEX_EXPRESSION, INVALID_CHAR_MESSAGE}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("Email", "Email", null));
    }

    public User getViewUser() throws Exception {
        RequestContext context = RequestContext.getCurrentInstance();
        String currentUserName = context.getRemoteUser();
        String currentViewer = URLUtils.getCurrentUser();
        if (currentViewer != null && currentViewer != currentUserName) {
            OrganizationService orgSer = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            UserHandler userHandler = orgSer.getUserHandler();
            return userHandler.findUserByName(currentViewer);
        }
        ConversationState state = ConversationState.getCurrent();
        return (User)state.getAttribute("UserProfile");
    }

    public void setValue() throws Exception {
        ConversationState state = ConversationState.getCurrent();
        User user = (User)state.getAttribute("UserProfile");
    }
}

