/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.portlet.profile.UIContactSection;
import org.exoplatform.social.portlet.profile.UIProfileSection;
import org.exoplatform.social.portlet.profile.UITitleBar;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/portal/webui/component/UIContactSection.gtmpl", events={@EventConfig(listeners={EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIProfileSection.CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})
public class UIContactSection
extends UIProfileSection {
    public static final String EMAILS = "emails";
    public static final String PHONES = "phones";
    public static final String IMS = "ims";
    public static final String URLS = "urls";
    public static final String URL = "url";
    public static final String EMAIL = "email";
    public static final String PHONE = "phone";
    public static final String FONE = "fone";
    public static final String RLU = "rlu";
    public static final String WORK = "Work";
    public static final String HOME = "Home";
    public static final String OTHER = "Other";
    public static final String GTALK = "Gtalk";
    public static final String MSN = "Msn";
    public static final String SKYPE = "Skype";
    public static final String YAHOO = "Yahoo";
    public static final String WEBSITE_TITLE = "Website Title";
    public static final String URL_EXAMPLE = "URL (ex: http://www.site.com)";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String EMAIL_REGEX_EXPRESSION = "^([^@\\s]+)@((?:[-a-z0-9]+\\.)+[a-z]{2,})$";
    public static final String INVALID_EMAIl = "UIContactSect.msg.Invalid-email";
    public static final String PHONE_REGEX_EXPRESSION = "^[\\d\\s ().-]+$";
    public static final String INVALID_PHONE = "UIContactSect.msg.Invalid-phone";
    public static final String URL_REGEX_EXPRESSION = "^(http|https|ftp)\\:\\/\\/[a-z0-9\\-\\.]+\\.[a-z]{2,3}(:[a-z0-9]*)?\\/?([a-z0-9\\-\\._\\?\\,\\'\\/\\\\+&amp;%\\$#\\=~])*$";
    public static final String INVALID_URL = "UIContactSect.msg.Invalid-url";
    public static final String GENDER_CHILD = "UITgender";
    public static final String GENDER = "gender";
    public static final String GENDER_DEFAULT = "Gender";
    public static final String MALE = "male";
    public static final String FEMALE = "female";
    private int emailCount = 0;
    private int phoneCount = 0;
    private int imsCount = 0;
    private int urlCount = 0;
    private int emailIdx = 0;
    private int phoneIdx = 0;
    private int imsIdx = 0;
    private int urlIdx = 0;

    public int getEmailCount() {
        return this.emailCount;
    }

    public int getPhoneCount() {
        return this.phoneCount;
    }

    public int getImsCount() {
        return this.imsCount;
    }

    public int getUrlCount() {
        return this.urlCount;
    }

    public UIContactSection() throws Exception {
        this.addChild(UITitleBar.class, null, null);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        options.add(new SelectItemOption((Object)GENDER_DEFAULT));
        options.add(new SelectItemOption((Object)MALE));
        options.add(new SelectItemOption((Object)FEMALE));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(GENDER_CHILD, GENDER_CHILD, options));
    }

    public List<UIComponent> getChilds() {
        List listChild = this.getChildren();
        return this.sort(listChild);
    }

    public List<UIComponent> getEmailChilds() {
        return this.sortSubList(this.getSubList(0, this.emailCount));
    }

    public List<UIComponent> getPhoneChilds() {
        return this.sortSubList(this.getSubList(this.emailCount, this.emailCount + this.phoneCount));
    }

    public List<UIComponent> getImsChilds() {
        return this.sortSubList(this.getSubList(this.emailCount + this.phoneCount, this.emailCount + this.phoneCount + this.imsCount));
    }

    public List<UIComponent> getUrlChilds() {
        return this.sortSubList(this.getSubList(this.emailCount + this.phoneCount + this.imsCount, this.emailCount + this.phoneCount + this.imsCount + this.urlCount));
    }

    public UIComponent getGenderChild() {
        return this.getChildById(GENDER_CHILD);
    }

    private void saveProfileInfo() throws Exception {
        ArrayList phones = new ArrayList();
        ArrayList ims = new ArrayList();
        ArrayList urls = new ArrayList();
        List listPhoneUIComp = this.getPhoneChilds();
        List listIMSUIComp = this.getImsChilds();
        List listURLUIComp = this.getUrlChilds();
        UIFormSelectBox uiGender = (UIFormSelectBox)this.getChildById(GENDER_CHILD);
        String gender = (String)uiGender.getValue();
        gender = GENDER_DEFAULT.equals(gender) ? "" : gender;
        phones = this.getProfileForSave(this.phoneCount, listPhoneUIComp, WORK);
        ims = this.getProfileForSave(this.imsCount, listIMSUIComp, null);
        urls = this.getProfileForSave(this.urlCount, listURLUIComp, URL);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        Profile p = this.getProfile(true);
        p.setProperty(PHONES, (Object)phones);
        p.setProperty(IMS, (Object)ims);
        p.setProperty(URLS, (Object)urls);
        p.setProperty(GENDER, (Object)gender);
        im.saveProfile(p);
    }

    private ArrayList<HashMap<String, String>> getProfileForSave(int count, List<UIComponent> listUIComp, String uiStringType) {
        ArrayList<HashMap<String, String>> profileMap = new ArrayList<HashMap<String, String>>();
        String value = null;
        String key = null;
        UIFormStringInput uiStringInput = null;
        UIFormSelectBox uiSelectBox = null;
        if (WORK.equals(uiStringType)) {
            for (int i = 0; i < count; ++i) {
                HashMap<String, String> uiMap = new HashMap<String, String>();
                key = uiStringType;
                uiStringInput = (UIFormStringInput)listUIComp.get(i);
                value = (String)uiStringInput.getValue();
                uiMap.put(KEY, key);
                uiMap.put(VALUE, value);
                profileMap.add(uiMap);
            }
        } else {
            for (int i = 0; i < count; i += 2) {
                HashMap<String, String> uiMap = new HashMap<String, String>();
                if (uiStringType == null) {
                    uiSelectBox = (UIFormSelectBox)listUIComp.get(i);
                    key = (String)uiSelectBox.getValue();
                    uiStringInput = (UIFormStringInput)listUIComp.get(i + 1);
                    value = (String)uiStringInput.getValue();
                } else {
                    uiStringInput = (UIFormStringInput)listUIComp.get(i + 1);
                    key = (String)uiStringInput.getValue();
                    value = (String)uiStringInput.getValue();
                }
                uiMap.put(KEY, key);
                uiMap.put(VALUE, value);
                profileMap.add(uiMap);
            }
        }
        return profileMap;
    }

    private List<UIComponent> getSubList(int startIdx, int endIdx) {
        ArrayList<UIComponent> rtnList = new ArrayList<UIComponent>();
        for (int idx = startIdx; idx < endIdx; ++idx) {
            rtnList.add((UIComponent)this.getChilds().get(idx));
        }
        return rtnList;
    }

    private void setValue() throws Exception {
        this.setValueByType(this.getPhoneChilds(), PHONES);
        this.setValueByType(this.getImsChilds(), IMS);
        this.setValueByType(this.getUrlChilds(), URLS);
    }

    private void setValueByType(List<UIComponent> listChilds, String uiType) throws Exception {
        block16: {
            int listProfileSize;
            ArrayList listProfile;
            block18: {
                block17: {
                    int totalProfile;
                    int listChildSize;
                    block15: {
                        Profile profile = this.getProfile(false);
                        ArrayList profiles = (ArrayList)profile.getProperty(uiType);
                        listProfile = new ArrayList();
                        listChildSize = listChilds.size();
                        String gender = (String)profile.getProperty(GENDER);
                        if (gender != "") {
                            ((UIFormInput)this.getGenderChild()).setValue((Object)gender);
                        }
                        if (profiles == null || profiles.size() == 0) {
                            if (listChildSize != 0) {
                                if (PHONES.equals(uiType)) {
                                    String id1 = listChilds.get(listChildSize - 1).getName();
                                    this.removeFormInput(id1, null);
                                    return;
                                }
                                String id1 = listChilds.get(listChildSize - 1).getName();
                                String id2 = listChilds.get(listChildSize - 2).getName();
                                this.removeFormInput(id1, id2);
                                return;
                            }
                            return;
                        }
                        for (HashMap map : profiles) {
                            listProfile.add(map.get(KEY));
                            listProfile.add(map.get(VALUE));
                        }
                        listProfileSize = listProfile.size();
                        totalProfile = 0;
                        if (!PHONES.equalsIgnoreCase(uiType)) break block15;
                        for (totalProfile = listProfileSize; totalProfile > 2 * listChildSize; totalProfile -= 2) {
                            this.addUIFormInput(PHONE);
                        }
                        for (totalProfile = listProfileSize; totalProfile < 2 * listChildSize; totalProfile += 2) {
                            String id1 = listChilds.get(listChildSize - 1).getName();
                            this.removeFormInput(id1, null);
                        }
                        for (int i = 0; i < listProfileSize / 2; ++i) {
                            ((UIFormInput)this.getPhoneChilds().get(i)).setValue(listProfile.get(2 * i + 1));
                        }
                        break block16;
                    }
                    for (totalProfile = listProfileSize; totalProfile > listChildSize; totalProfile -= 2) {
                        if (EMAILS.equals(uiType)) {
                            this.addUIFormInput(EMAIL);
                            continue;
                        }
                        if (IMS.equals(uiType)) {
                            this.addUIFormInput(IMS);
                            continue;
                        }
                        if (!URLS.equals(uiType)) continue;
                        this.addUIFormInput(RLU);
                    }
                    for (totalProfile = listProfileSize; totalProfile < listChildSize; totalProfile += 2) {
                        String id1 = listChilds.get(listChildSize - 1).getName();
                        String id2 = listChilds.get(listChildSize - 2).getName();
                        this.removeFormInput(id1, id2);
                    }
                    if (!EMAILS.equals(uiType)) break block17;
                    for (int i = 0; i <= listProfileSize - 1; ++i) {
                        ((UIFormInput)this.getEmailChilds().get(i)).setValue(listProfile.get(i));
                    }
                    break block16;
                }
                if (!IMS.equals(uiType)) break block18;
                for (int i = 0; i <= listProfileSize - 1; ++i) {
                    ((UIFormInput)this.getImsChilds().get(i)).setValue(listProfile.get(i));
                }
                break block16;
            }
            if (!URLS.equals(uiType)) break block16;
            for (int i = 0; i <= listProfileSize - 1; ++i) {
                ((UIFormInput)this.getUrlChilds().get(i)).setValue(listProfile.get(i));
            }
        }
    }

    private void removeFormInput(String id1, String id2) {
        if (id1.startsWith(FONE)) {
            this.removeChildById(id1);
            --this.phoneCount;
        } else {
            this.removeChildById(id1);
            this.removeChildById(id2);
            if (id1.startsWith(EMAIL)) {
                this.emailCount -= 2;
            } else if (id1.startsWith(IMS)) {
                this.imsCount -= 2;
            } else if (id1.startsWith(RLU)) {
                this.urlCount -= 2;
            }
        }
    }

    private void addUIFormInput(String type) throws Exception {
        if (EMAIL.equals(type)) {
            this.createUISelectBox(new String[]{WORK, HOME, OTHER}, EMAIL);
            this.addUIFormInput((UIFormInput)new UIFormStringInput(EMAIL + ++this.emailIdx, null, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(ExpressionValidator.class, new Object[]{EMAIL_REGEX_EXPRESSION, INVALID_EMAIl}));
        } else if (PHONE.equals(type)) {
            ++this.phoneCount;
            this.addUIFormInput((UIFormInput)new UIFormStringInput(FONE + ++this.phoneIdx, null, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 20}).addValidator(ExpressionValidator.class, new Object[]{PHONE_REGEX_EXPRESSION, INVALID_PHONE}));
        } else if (IMS.equals(type)) {
            this.createUISelectBox(new String[]{GTALK, MSN, SKYPE, YAHOO, OTHER}, IMS);
            this.addUIFormInput((UIFormInput)new UIFormStringInput(IMS + ++this.imsIdx, null, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 60}));
        } else {
            this.urlCount += 2;
            this.addUIFormInput((UIFormInput)new UIFormStringInput(RLU + ++this.urlIdx, null, WEBSITE_TITLE));
            this.addUIFormInput((UIFormInput)new UIFormStringInput(RLU + ++this.urlIdx, null, URL_EXAMPLE).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{URL_REGEX_EXPRESSION, INVALID_URL}));
        }
    }

    private void createUISelectBox(String[] values, String uiName) {
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        int len = values.length;
        for (int idx = 0; idx < len; ++idx) {
            options.add(new SelectItemOption((Object)values[idx]));
        }
        if (EMAIL.equals(uiName)) {
            this.emailCount += 2;
            this.addUIFormInput((UIFormInput)new UIFormSelectBox(uiName + ++this.emailIdx, null, options));
        } else if (IMS.equals(uiName)) {
            this.imsCount += 2;
            this.addUIFormInput((UIFormInput)new UIFormSelectBox(uiName + ++this.imsIdx, null, options));
        }
    }

    private List<UIComponent> sort(List<UIComponent> lstComps) {
        Collections.sort(lstComps, new UiComponentComparator(this, null));
        return lstComps;
    }

    private List<UIComponent> sortSubList(List<UIComponent> lstComps) {
        Collections.sort(lstComps, new UIComparator(this, null));
        return lstComps;
    }

    static /* synthetic */ void access$000(UIContactSection x0) throws Exception {
        x0.saveProfileInfo();
    }

    static /* synthetic */ void access$100(UIContactSection x0, String x1) throws Exception {
        x0.addUIFormInput(x1);
    }

    static /* synthetic */ void access$200(UIContactSection x0, String x1, String x2) {
        x0.removeFormInput(x1, x2);
    }

    static /* synthetic */ void access$300(UIContactSection x0) throws Exception {
        x0.setValue();
    }
}

