/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.profile;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.portlet.profile.UIExperienceSection;
import org.exoplatform.social.portlet.profile.UIProfileSection;
import org.exoplatform.social.portlet.profile.UITitleBar;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/portal/webui/component/UIExperienceSection.gtmpl", events={@EventConfig(listeners={EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIProfileSection.CancelActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIFormCheckBoxInput.class, id="UIFormCheckBoxEndDate", events={@EventConfig(phase=Event.Phase.DECODE, listeners={ShowHideEndDateActionListener.class})})})
public class UIExperienceSection
extends UIProfileSection {
    public static final String COMPANY = "company";
    public static final String POSITION = "position";
    public static final String PROFESSIONAL = "professional";
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String IS_CURRENT = "isCurrent";
    public static final String DESCRIPTION = "description";
    public static final String EXPERIENCE = "experiences";
    public static final String DATE_AFTER_TODAY = "UIExperienceSection.msg.DateAfterToday";
    public static final String STARTDATE_BEFORE_ENDDATE = "UIExperienceSection.msg.startDateBeforeEndDate";
    public static final String DATE_FORMAT_MMDDYYYY = "MM/dd/yyyy";
    int expIdx = 0;

    public int getExpCount() {
        return this.expIdx;
    }

    public List<UIComponent> getChilds() {
        return this.getChildren();
    }

    public UIExperienceSection() throws Exception {
        this.addChild(UITitleBar.class, null, null);
    }

    public int getMonth(String inDate) throws ParseException {
        if (inDate == null || inDate.length() == 0) {
            return 0;
        }
        Calendar calendar = this.getCalendar(inDate);
        return calendar.get(2) + 1;
    }

    public int getDate(String inDate) throws ParseException {
        if (inDate == null || inDate.length() == 0) {
            return 0;
        }
        Calendar calendar = this.getCalendar(inDate);
        return calendar.get(5);
    }

    public int getYear(String inDate) throws ParseException {
        if (inDate == null || inDate.length() == 0) {
            return 0;
        }
        Calendar calendar = this.getCalendar(inDate);
        return calendar.get(1);
    }

    public List<HashMap<String, Object>> getPastExperience() throws Exception {
        ArrayList experiences = new ArrayList();
        ArrayList<HashMap<String, Object>> pastExperiences = new ArrayList<HashMap<String, Object>>();
        Profile p = this.getProfile(false);
        experiences = (ArrayList)p.getProperty(EXPERIENCE);
        if (experiences != null) {
            for (HashMap map : experiences) {
                if (((Boolean)map.get(IS_CURRENT)).booleanValue()) continue;
                pastExperiences.add(map);
            }
        }
        return pastExperiences;
    }

    public List<HashMap<String, Object>> getCurrentExperience() throws Exception {
        ArrayList experiences = new ArrayList();
        ArrayList<HashMap<String, Object>> currentExperiences = new ArrayList<HashMap<String, Object>>();
        Profile p = this.getProfile(false);
        experiences = (ArrayList)p.getProperty(EXPERIENCE);
        if (experiences != null) {
            for (HashMap map : experiences) {
                if (!((Boolean)map.get(IS_CURRENT)).booleanValue()) continue;
                currentExperiences.add(map);
            }
        }
        return currentExperiences;
    }

    private int saveProfileInfo() throws Exception {
        ArrayList experiences = new ArrayList();
        UIFormStringInput uiStringInput = null;
        UIFormTextAreaInput uiFormTextAreaInput = null;
        UIFormCheckBoxInput uiCheckBox = null;
        UIFormDateTimeInput uiDateTimeInput = null;
        String company = null;
        String position = null;
        String professional = null;
        String startDate = null;
        String endDate = null;
        Boolean isCurrent = null;
        String description = null;
        Date sDate = null;
        Date eDate = null;
        Date today = new Date();
        UIPortalApplication uiPortalApplication = Util.getUIPortalApplication();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        Profile p = this.getProfile(true);
        List listUIComp = this.getChilds();
        int totalUIComponent = listUIComp.size() - 1;
        if (totalUIComponent == 0) {
            if (p != null) {
                p.setProperty(EXPERIENCE, experiences);
                im.saveProfile(p);
            }
            return 0;
        }
        for (int i = 1; i <= totalUIComponent; i += 7) {
            HashMap<String, Object> uiMap = new HashMap<String, Object>();
            uiStringInput = (UIFormStringInput)listUIComp.get(i);
            company = (String)uiStringInput.getValue();
            uiStringInput = (UIFormStringInput)listUIComp.get(i + 1);
            position = (String)uiStringInput.getValue();
            uiFormTextAreaInput = (UIFormTextAreaInput)listUIComp.get(i + 2);
            professional = (String)uiFormTextAreaInput.getValue();
            uiDateTimeInput = (UIFormDateTimeInput)listUIComp.get(i + 3);
            startDate = (String)uiDateTimeInput.getValue();
            uiCheckBox = (UIFormCheckBoxInput)listUIComp.get(i + 4);
            isCurrent = (Boolean)uiCheckBox.getValue();
            uiDateTimeInput = (UIFormDateTimeInput)listUIComp.get(i + 5);
            endDate = (String)uiDateTimeInput.getValue();
            sDate = this.stringToDate(startDate);
            eDate = this.stringToDate(endDate);
            if (sDate.after(today)) {
                uiPortalApplication.addMessage(new ApplicationMessage(DATE_AFTER_TODAY, null));
                return 2;
            }
            if (!isCurrent.booleanValue()) {
                if (eDate.after(today)) {
                    uiPortalApplication.addMessage(new ApplicationMessage(DATE_AFTER_TODAY, null));
                    return 2;
                }
                if (sDate.after(eDate)) {
                    uiPortalApplication.addMessage(new ApplicationMessage(STARTDATE_BEFORE_ENDDATE, null));
                    return 1;
                }
            } else {
                endDate = null;
            }
            uiStringInput = (UIFormStringInput)listUIComp.get(i + 6);
            description = (String)uiStringInput.getValue();
            uiMap.put(COMPANY, company);
            uiMap.put(POSITION, position);
            uiMap.put(PROFESSIONAL, professional);
            uiMap.put(START_DATE, startDate);
            uiMap.put(END_DATE, endDate);
            uiMap.put(IS_CURRENT, isCurrent);
            uiMap.put(DESCRIPTION, description);
            experiences.add(uiMap);
        }
        p.setProperty(EXPERIENCE, experiences);
        im.saveProfile(p);
        return 0;
    }

    private void addUIFormInput() throws Exception {
        ++this.expIdx;
        this.addUIFormInput((UIFormInput)new UIFormStringInput(COMPANY + this.expIdx, null, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 90}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(POSITION + this.expIdx, null, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 90}));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(PROFESSIONAL + this.expIdx, null, null));
        UIFormTextAreaInput uiFormTextAreaInput = (UIFormTextAreaInput)this.getChildById(PROFESSIONAL + this.expIdx);
        uiFormTextAreaInput.setColumns(23);
        uiFormTextAreaInput.setRows(3);
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput(START_DATE + this.expIdx, null, null, false).addValidator(DateTimeValidator.class, new Object[0]).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormCheckBoxInput uiDateInputCheck = new UIFormCheckBoxInput(Integer.toString(this.expIdx), null, (Object)false);
        uiDateInputCheck.setComponentConfig(UIFormCheckBoxInput.class, "UIFormCheckBoxEndDate");
        uiDateInputCheck.setOnChange("ShowHideEndDate", uiDateInputCheck.getId());
        this.addUIFormInput((UIFormInput)uiDateInputCheck);
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput(END_DATE + this.expIdx, null, null, false).addValidator(MandatoryValidator.class, new Object[0]).addValidator(DateTimeValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DESCRIPTION + this.expIdx, null, null));
    }

    private Date stringToDate(String dateStr) throws ParseException {
        SimpleDateFormat formatDate = new SimpleDateFormat(DATE_FORMAT_MMDDYYYY);
        if (dateStr == null || dateStr.length() == 0) {
            return null;
        }
        return formatDate.parse(dateStr);
    }

    private Calendar getCalendar(String inDate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_MMDDYYYY);
        Date date = format.parse(inDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    static /* synthetic */ void access$000(UIExperienceSection x0) throws Exception {
        x0.addUIFormInput();
    }

    static /* synthetic */ int access$100(UIExperienceSection x0) throws Exception {
        return x0.saveProfileInfo();
    }
}

