/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.profile;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.model.ProfileAttachment;
import org.exoplatform.social.portlet.profile.UIBasicInfoSection;
import org.exoplatform.social.portlet.profile.UIContactSection;
import org.exoplatform.social.portlet.profile.UIExperienceSection;
import org.exoplatform.social.portlet.profile.UIHeaderSection;
import org.exoplatform.social.portlet.profile.UIProfile;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/portal/webui/component/UIProfile.gtmpl", events={@EventConfig(listeners={ChangeAvatarActionListener.class})})
public class UIProfile
extends UIContainer {
    private final String POPUP_AVATAR_UPLOADER = "UIPopupAvatarUploader";
    private Profile profile;
    private static IdentityManager im;

    public UIProfile() throws Exception {
        List sections = this.getSections();
        for (Class sect : sections) {
            this.addChild(sect, null, null);
        }
        UIPopupWindow uiPopup = (UIPopupWindow)this.createUIComponent(UIPopupWindow.class, null, "UIPopupAvatarUploader");
        uiPopup.setWindowSize(500, 0);
        this.addChild((UIComponent)uiPopup);
    }

    private List getSections() {
        ArrayList<Class> sects = new ArrayList<Class>();
        sects.add(UIHeaderSection.class);
        sects.add(UIBasicInfoSection.class);
        sects.add(UIContactSection.class);
        sects.add(UIExperienceSection.class);
        return sects;
    }

    public String getCurrentUriObj() {
        String portalUrl;
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String requestUrl = pcontext.getRequestURI();
        String uriObj = requestUrl.replace(portalUrl = pcontext.getPortalURI(), "");
        if (uriObj.contains("/")) {
            uriObj = uriObj.split("/")[0] + "/" + uriObj.split("/")[1];
        }
        return uriObj;
    }

    private Identity getIdentity() throws Exception {
        if (im == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return im.getIdentityByRemoteId("organization", this.getCurrentProfileID());
    }

    public Profile getProfile(boolean forceReload) throws Exception {
        if (forceReload || this.profile == null) {
            Identity id = this.getIdentity();
            this.profile = id.getProfile();
        }
        return this.profile;
    }

    public boolean isEditable() {
        RequestContext context = RequestContext.getCurrentInstance();
        String rUser = context.getRemoteUser();
        if (rUser == null) {
            return false;
        }
        return this.getCurrentProfileID().equals(rUser);
    }

    public String getImageSource() throws Exception {
        Profile p = this.getProfile(true);
        ProfileAttachment att = (ProfileAttachment)p.getProperty("avatar");
        if (att != null) {
            return "/" + this.getPortalName() + "/rest/jcr/" + this.getRepository() + "/" + att.getWorkspace() + att.getDataPath() + "/?rnd=" + System.currentTimeMillis();
        }
        return null;
    }

    private String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private String getCurrentProfileID() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }
}

