/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.profilelist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.Relationship;
import org.exoplatform.social.core.relationship.RelationshipManager;
import org.exoplatform.social.portlet.profilelist.UIDisplayProfileList;
import org.exoplatform.social.relation.IdentityListAccess;
import org.exoplatform.social.webui.UIProfileUserSearch;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/portal/webui/component/UIDisplayProfileList.gtmpl", events={@EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={AcceptContactActionListener.class}), @EventConfig(listeners={DenyContactActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIDisplayProfileList
extends UIContainer {
    private static final String INVITATION_REVOKED_INFO = "UIDisplayProfileList.label.RevokedInfo";
    private static final String INVITATION_ESTABLISHED_INFO = "UIDisplayProfileList.label.InvitationEstablishedInfo";
    private IdentityManager identityManager_ = null;
    UIProfileUserSearch uiProfileUserSearchPeople = null;
    private UIPageIterator iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorPeople");
    private final Integer PEOPLE_PER_PAGE = 10;
    private final String ITERATOR_ID = "UIIteratorPeople";
    private List<Identity> identityList;

    public List<Identity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    public UIDisplayProfileList() throws Exception {
        this.uiProfileUserSearchPeople = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.uiProfileUserSearchPeople.setAllUserContactName(this.loadAllUserNames());
        this.addChild((UIComponent)this.uiProfileUserSearchPeople);
    }

    public List<Identity> getList() throws Exception {
        int currentPage = this.iterator.getCurrentPage();
        List peopleList = this.getProfiles();
        LazyPageList pageList = new LazyPageList((ListAccess)new IdentityListAccess(peopleList), this.PEOPLE_PER_PAGE.intValue());
        this.iterator.setPageList((PageList)pageList);
        int pageCount = this.iterator.getAvailablePage();
        if (pageCount >= currentPage) {
            this.iterator.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.iterator.setCurrentPage(currentPage - 1);
        }
        return this.iterator.getCurrentPageData();
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager_ == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.identityManager_ = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager_;
    }

    private List<Identity> getProfiles() throws Exception {
        List matchIdentities = this.getIdentityList();
        if (matchIdentities == null) {
            return this.loadAllProfiles();
        }
        Iterator itr = matchIdentities.iterator();
        while (itr.hasNext()) {
            Identity id = (Identity)itr.next();
            if (id.getId() != this.getCurrentIdentity().getId()) continue;
            itr.remove();
        }
        return matchIdentities;
    }

    public Identity getCurrentViewerIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        return im.getIdentityByRemoteId("organization", this.getCurrentViewerUserName());
    }

    private String getCurrentViewerUserName() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        return portalRequest.getRemoteUser();
    }

    private List<Identity> loadAllProfiles() throws Exception {
        IdentityManager im = this.getIdentityManager();
        List ids = im.getIdentities("organization");
        Iterator itr = ids.iterator();
        while (itr.hasNext()) {
            Identity id = (Identity)itr.next();
            if (id.getId() != this.getCurrentIdentity().getId()) continue;
            itr.remove();
        }
        return ids;
    }

    private List<String> loadAllUserNames() throws Exception {
        ArrayList<String> allUserContactName = new ArrayList<String>();
        List allIds = this.loadAllProfiles();
        for (Identity identity : allIds) {
            allUserContactName.add(identity.getProfile().getFullName());
        }
        return allUserContactName;
    }

    public Relationship.Type getContactStatus(Identity identity) throws Exception {
        if (identity.getId().equals(this.getCurrentIdentity().getId())) {
            return Relationship.Type.SELF;
        }
        RelationshipManager rm = this.getRelationshipManager();
        Relationship rl = rm.getRelationship(identity, this.getCurrentIdentity());
        return rm.getRelationshipStatus(rl, this.getCurrentIdentity());
    }

    private RelationshipManager getRelationshipManager() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public String getCurrentUserName() {
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    public Identity getCurrentIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        return im.getIdentityByRemoteId("organization", this.getCurrentUserName());
    }

    public String getPath() {
        String nodePath = Util.getPortalRequestContext().getNodePath();
        String uriPath = Util.getPortalRequestContext().getRequestURI();
        return uriPath.replaceAll(nodePath, "");
    }

    static /* synthetic */ IdentityManager access$000(UIDisplayProfileList x0) {
        return x0.getIdentityManager();
    }

    static /* synthetic */ RelationshipManager access$100(UIDisplayProfileList x0) {
        return x0.getRelationshipManager();
    }
}

