/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.relation;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.Relationship;
import org.exoplatform.social.core.relationship.RelationshipManager;
import org.exoplatform.social.relation.RelationshipListAccess;
import org.exoplatform.social.relation.UIMyRelations;
import org.exoplatform.social.webui.UIProfileUserSearch;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormPageIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/portal/webui/component/UIMyRelations.gtmpl", events={@EventConfig(listeners={RemoveActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIMyRelations
extends UIContainer {
    UIFormPageIterator uiFormPageIteratorContact = (UIFormPageIterator)this.createUIComponent(UIFormPageIterator.class, null, "UIFormPageIteratorContact");
    private final String iteratorIDContact = "UIFormPageIteratorContact";
    private static final String RELATION_DELETED_INFO = "UIMyRelations.label.DeletedInfo";
    private RelationshipManager relationshipManager;
    private IdentityManager identityManager = null;
    UIProfileUserSearch uiProfileUserSearchRelation = null;
    private List<Identity> identityList;

    public List<Identity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIFormPageIterator getUiFormPageIteratorContact() {
        return this.uiFormPageIteratorContact;
    }

    public UIMyRelations() throws Exception {
        this.addChild((UIComponent)this.uiFormPageIteratorContact);
        this.uiProfileUserSearchRelation = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.addChild((UIComponent)this.uiProfileUserSearchRelation);
    }

    public List<Relationship> getMyRelation() throws Exception {
        List listContacts = this.getMyContacts();
        List contactLists = this.getDisplayRelationList(listContacts, this.uiFormPageIteratorContact);
        this.uiProfileUserSearchRelation.setAllUserContactName(this.getAllMyRelationUserNames());
        return contactLists;
    }

    private List<Relationship> getDisplayRelationList(List<Relationship> listContacts, UIFormPageIterator uiFormPageIterator) throws Exception {
        int curPage = uiFormPageIterator.getCurrentPage();
        LazyPageList pageListContact = new LazyPageList((ListAccess)new RelationshipListAccess(listContacts), 5);
        uiFormPageIterator.setPageList((PageList)pageListContact);
        int availablePageCount = uiFormPageIterator.getAvailablePage();
        if (availablePageCount >= curPage) {
            uiFormPageIterator.setCurrentPage(curPage);
        } else if (availablePageCount < curPage) {
            uiFormPageIterator.setCurrentPage(curPage - 1);
        }
        List contactLists = uiFormPageIterator.getCurrentPageData();
        return contactLists;
    }

    public Identity getCurrentIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        return im.getIdentityByRemoteId("organization", this.getCurrentViewerUserName());
    }

    public Identity getCurrentViewerIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        Identity identity = im.getIdentityByRemoteId("organization", this.getCurrentViewerUserName());
        if (identity == null) {
            identity = im.getIdentityByRemoteId("organization", this.getCurrentUserName());
        }
        return identity;
    }

    public boolean isEditable() {
        RequestContext context = RequestContext.getCurrentInstance();
        String currentUserName = context.getRemoteUser();
        String currentViewer = URLUtils.getCurrentUser();
        return currentUserName.equals(currentViewer);
    }

    private List<String> getAllMyRelationUserNames() throws Exception {
        RelationshipManager relm = this.getRelationshipManager();
        Identity currentIdentity = this.getCurrentViewerIdentity();
        ArrayList<Identity> allRelationIdentities = new ArrayList<Identity>();
        List allRelations = relm.getContacts(currentIdentity);
        Identity id = null;
        Identity currIdentity = this.getCurrentIdentity();
        for (Relationship rel : allRelations) {
            id = currIdentity.getId() == rel.getIdentity1().getId() ? rel.getIdentity2() : rel.getIdentity1();
            allRelationIdentities.add(id);
        }
        ArrayList<String> allUserContactName = new ArrayList<String>();
        for (Identity identity : allRelationIdentities) {
            allUserContactName.add(identity.getProfile().getFullName());
        }
        return allUserContactName;
    }

    private List<Relationship> getMyContacts() throws Exception {
        RelationshipManager relm = this.getRelationshipManager();
        Identity currentIdentity = this.getCurrentViewerIdentity();
        List matchIdentities = this.getIdentityList();
        if (matchIdentities == null) {
            return relm.getContacts(currentIdentity);
        }
        return relm.getContacts(currentIdentity, matchIdentities);
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    private String getCurrentViewerUserName() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        return portalRequest.getRemoteUser();
    }

    private String getCurrentUserName() {
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        return portalRequest.getRemoteUser();
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.relationshipManager = (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }

    private Relationship.Type getContactStatus(Identity identity) throws Exception {
        if (identity.getId().equals(this.getCurrentIdentity().getId())) {
            return Relationship.Type.SELF;
        }
        RelationshipManager rm = this.getRelationshipManager();
        Relationship rl = rm.getRelationship(identity, this.getCurrentIdentity());
        return rm.getRelationshipStatus(rl, this.getCurrentIdentity());
    }

    static /* synthetic */ String access$000(UIMyRelations x0) {
        return x0.getCurrentUserName();
    }

    static /* synthetic */ IdentityManager access$100(UIMyRelations x0) {
        return x0.getIdentityManager();
    }

    static /* synthetic */ RelationshipManager access$200(UIMyRelations x0) {
        return x0.getRelationshipManager();
    }

    static /* synthetic */ Relationship.Type access$300(UIMyRelations x0, Identity x1) throws Exception {
        return x0.getContactStatus(x1);
    }
}

