/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.relation;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.Relationship;
import org.exoplatform.social.core.relationship.RelationshipManager;
import org.exoplatform.social.relation.RelationshipListAccess;
import org.exoplatform.social.relation.UIPendingRelation;
import org.exoplatform.social.webui.UIProfileUserSearch;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormPageIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/portal/webui/component/UIPendingRelation.gtmpl", events={@EventConfig(listeners={DenyContactActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIPendingRelation
extends UIContainer {
    UIFormPageIterator uiFormPageIterator_ = (UIFormPageIterator)this.createUIComponent(UIFormPageIterator.class, null, "UIFormPageIteratorPendingRelation");
    private final String iteratorID_ = "UIFormPageIteratorPendingRelation";
    private static final String INVITATION_REVOKED_INFO = "UIPendingRelation.label.RevokedInfo";
    Identity currIdentity = null;
    RelationshipManager rm = null;
    IdentityManager im = null;
    UIProfileUserSearch uiProfileUserSearchPending = null;
    private List<Identity> identityList;

    public List<Identity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIFormPageIterator getUiFormPageIterator() {
        return this.uiFormPageIterator_;
    }

    public UIPendingRelation() throws Exception {
        this.addChild((UIComponent)this.uiFormPageIterator_);
        this.uiProfileUserSearchPending = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.addChild((UIComponent)this.uiProfileUserSearchPending);
    }

    public List<Relationship> getPendingRelationList() throws Exception {
        List listRelationShip = this.getPendingRelationships();
        int currentPage = this.uiFormPageIterator_.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new RelationshipListAccess(listRelationShip), 5);
        this.uiProfileUserSearchPending.setAllUserContactName(this.getAllPendingUserNames());
        this.uiFormPageIterator_.setPageList((PageList)pageList);
        int pageCount = this.uiFormPageIterator_.getAvailablePage();
        if (pageCount >= currentPage) {
            this.uiFormPageIterator_.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.uiFormPageIterator_.setCurrentPage(currentPage - 1);
        }
        List lists = this.uiFormPageIterator_.getCurrentPageData();
        return lists;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public Identity getCurrentIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        return im.getIdentityByRemoteId("organization", this.getCurrentUserName());
    }

    public Identity getCurrentViewerIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        Identity identity = im.getIdentityByRemoteId("organization", this.getCurrentViewerUserName());
        if (identity == null) {
            identity = im.getIdentityByRemoteId("organization", this.getCurrentUserName());
        }
        return identity;
    }

    public String getCurrentUserName() {
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    public String getCurrentViewerUserName() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    public boolean isEditable() {
        RequestContext context = RequestContext.getCurrentInstance();
        String currentUserName = context.getRemoteUser();
        String currentViewer = URLUtils.getCurrentUser();
        return currentUserName.equals(currentViewer);
    }

    private List<String> getAllPendingUserNames() throws Exception {
        RelationshipManager relm = this.getRelationshipManager();
        Identity currentIdentity = this.getCurrentViewerIdentity();
        ArrayList<Identity> allPendingIdentities = new ArrayList<Identity>();
        List allPendings = relm.getPending(currentIdentity, true);
        Identity id = null;
        Identity currIdentity = this.getCurrentIdentity();
        for (Relationship rel : allPendings) {
            id = currIdentity.getId() == rel.getIdentity1().getId() ? rel.getIdentity2() : rel.getIdentity1();
            allPendingIdentities.add(id);
        }
        ArrayList<String> allUserContactName = new ArrayList<String>();
        for (Identity identity : allPendingIdentities) {
            allUserContactName.add(identity.getProfile().getFullName());
        }
        return allUserContactName;
    }

    private List<Relationship> getPendingRelationships() throws Exception {
        RelationshipManager relm = this.getRelationshipManager();
        Identity currentIdentity = this.getCurrentViewerIdentity();
        List matchIdentities = this.getIdentityList();
        if (matchIdentities == null) {
            return relm.getPending(currentIdentity, true);
        }
        return relm.getPending(currentIdentity, matchIdentities, true);
    }

    private RelationshipManager getRelationshipManager() {
        if (this.rm == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.rm = (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.rm;
    }

    private IdentityManager getIdentityManager() {
        if (this.im == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.im;
    }

    private Relationship.Type getContactStatus(Identity identity) throws Exception {
        if (identity.getId().equals(this.getCurrentIdentity().getId())) {
            return Relationship.Type.SELF;
        }
        RelationshipManager rm = this.getRelationshipManager();
        Relationship rl = rm.getRelationship(identity, this.getCurrentIdentity());
        return rm.getRelationshipStatus(rl, this.getCurrentIdentity());
    }

    static /* synthetic */ IdentityManager access$000(UIPendingRelation x0) {
        return x0.getIdentityManager();
    }

    static /* synthetic */ Relationship.Type access$100(UIPendingRelation x0, Identity x1) throws Exception {
        return x0.getContactStatus(x1);
    }

    static /* synthetic */ RelationshipManager access$200(UIPendingRelation x0) {
        return x0.getRelationshipManager();
    }
}

