/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.profile;

import java.util.List;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.portlet.profile.UIBasicInfoSection;
import org.exoplatform.social.portlet.profile.UIProfileSection;
import org.exoplatform.social.portlet.profile.UITitleBar;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/portal/webui/component/UIBasicInfoSection.gtmpl", events={@EventConfig(listeners={EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIProfileSection.CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIBasicInfoSection
extends UIProfileSection {
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String GENDER = "gender";
    public static final String GENDER_DEFAULT = "Gender";
    public static final String MALE = "male";
    public static final String FEMALE = "female";
    public static final String REGEX_EXPRESSION = "^\\p{L}[\\p{L}\\d._,\\s]+\\p{L}$";
    public static final String INVALID_CHAR_MESSAGE = "UIBasicInfoSection.msg.Invalid-char";

    public UIBasicInfoSection() throws Exception {
        String username = Util.getPortalRequestContext().getRemoteUser();
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        User useraccount = service.getUserHandler().findUserByName(username);
        this.addChild(UITitleBar.class, null, null);
        UIFormStringInput userName = new UIFormStringInput("userName", "userName", username);
        userName.setEditable(false);
        this.addUIFormInput((UIFormInput)userName);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIRST_NAME, FIRST_NAME, useraccount.getFirstName()).addValidator(StringLengthValidator.class, new Object[]{3, 45}).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^[\\p{L}][\\p{L}._'\\- \\d]+$", "FirstCharacterNameValidator.msg"}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(LAST_NAME, LAST_NAME, useraccount.getLastName()).addValidator(StringLengthValidator.class, new Object[]{3, 45}).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^[\\p{L}][\\p{L}._'\\- \\d]+$", "FirstCharacterNameValidator.msg"}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("email", "email", useraccount.getEmail()).addValidator(MandatoryValidator.class, new Object[0]).addValidator(EmailAddressValidator.class, new Object[0]));
    }

    public User getViewUser() throws Exception {
        RequestContext context = RequestContext.getCurrentInstance();
        String currentUserName = context.getRemoteUser();
        String currentViewer = URLUtils.getCurrentUser();
        if (currentViewer != null && currentViewer != currentUserName) {
            OrganizationService orgSer = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            UserHandler userHandler = orgSer.getUserHandler();
            return userHandler.findUserByName(currentViewer);
        }
        ConversationState state = ConversationState.getCurrent();
        return (User)state.getAttribute("UserProfile");
    }

    public List<UIComponent> getChilds() {
        return this.getChildren();
    }
}

