/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UISearch;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import social.portal.webui.component.UIInviteUsers;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={SelectUserActionListener.class})})
public class UIInviteUsers
extends UISearch
implements UIPopupComponent {
    public static String USER_NAME = "userName";
    public static String LAST_NAME = "lastName";
    public static String FIRST_NAME = "firstName";
    public static String EMAIL = "email";
    private static String[] USER_BEAN_FIELD = new String[]{USER_NAME, LAST_NAME, FIRST_NAME, EMAIL};
    private static String[] USER_ACTION = new String[]{"SelectUser"};
    private static List<SelectItemOption<String>> OPTIONS_ = new ArrayList(4);
    private String userSelected_;
    private UIGrid grid_ = (UIGrid)this.addChild(UIGrid.class, null, "UIInviteUsersGird");

    public UIInviteUsers() throws Exception {
        super(OPTIONS_);
        this.grid_.configure(USER_NAME, USER_BEAN_FIELD, USER_ACTION);
        this.grid_.getUIPageIterator().setId("UIInviteUsersIterator");
        this.grid_.getUIPageIterator().setParent((UIComponent)this);
        this.search(new Query());
    }

    public void setUserSelected(String userName) {
        this.userSelected_ = userName;
    }

    public String getUserSelected() {
        return this.userSelected_;
    }

    public void search(Query query) throws Exception {
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        PageList pageList = service.getUserHandler().findUsers(query);
        pageList.setPageSize(10);
        this.grid_.getUIPageIterator().setPageList(pageList);
        UIPageIterator pageIterator = this.grid_.getUIPageIterator();
        if (pageIterator.getAvailable() == 0) {
            UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
            uiApp.addMessage(new ApplicationMessage("UISearchForm.msg.empty", null));
            Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
        }
    }

    public void quickSearch(UIFormInputSet quickSearchInput) throws Exception {
        Query query = new Query();
        UIFormStringInput input = (UIFormStringInput)quickSearchInput.getChild(0);
        UIFormSelectBox select = (UIFormSelectBox)quickSearchInput.getChild(1);
        String name = (String)input.getValue();
        if (name == null || name.equals("")) {
            this.search(new Query());
            return;
        }
        if (name.indexOf("*") < 0) {
            if (name.charAt(0) != '*') {
                name = "*" + name;
            }
            if (name.charAt(name.length() - 1) != '*') {
                name = name + "*";
            }
        }
        name = name.replace('?', '_');
        String selectBoxValue = (String)select.getValue();
        if (selectBoxValue.equals(USER_NAME)) {
            query.setUserName(name);
        }
        if (selectBoxValue.equals(LAST_NAME)) {
            query.setLastName(name);
        }
        if (selectBoxValue.equals(FIRST_NAME)) {
            query.setFirstName(name);
        }
        if (selectBoxValue.equals(EMAIL)) {
            query.setEmail(name);
        }
        this.search(query);
    }

    public void advancedSearch(UIFormInputSet advancedSearchInput) throws Exception {
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static {
        OPTIONS_.add(new SelectItemOption(USER_NAME, (Object)USER_NAME));
        OPTIONS_.add(new SelectItemOption(LAST_NAME, (Object)LAST_NAME));
        OPTIONS_.add(new SelectItemOption(FIRST_NAME, (Object)FIRST_NAME));
        OPTIONS_.add(new SelectItemOption(EMAIL, (Object)EMAIL));
    }
}

