/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component;

import java.util.Iterator;
import java.util.List;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import social.portal.webui.component.UIManageSpaceWorkingArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/portal/webui/component/UIManageSpaceWorkingArea.gtmpl", events={@EventConfig(listeners={RequestJoinActionListener.class}), @EventConfig(listeners={ChangeListSpacesActionListener.class}), @EventConfig(listeners={EditSpaceActionListener.class}), @EventConfig(listeners={LeaveSpaceActionListener.class}), @EventConfig(listeners={AcceptUserActionListener.class}), @EventConfig(listeners={DenyUserActionListener.class})})
public class UIManageSpaceWorkingArea
extends UIContainer {
    private boolean isAllSpace = false;

    public List<Space> getAllSpaces() throws Exception {
        SpaceService spaceSrc = (SpaceService)this.getApplicationComponent(SpaceService.class);
        List allSpaces = spaceSrc.getAllSpaces();
        OrganizationService orgSrc = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        MembershipHandler memberShipHandler = orgSrc.getMembershipHandler();
        String userName = Util.getPortalRequestContext().getRemoteUser();
        if (!this.isAllSpace) {
            Iterator itr = allSpaces.iterator();
            while (itr.hasNext()) {
                Space space = (Space)itr.next();
                if (memberShipHandler.findMembershipsByUserAndGroup(userName, space.getGroupId()).size() != 0) continue;
                itr.remove();
            }
        }
        return allSpaces;
    }

    public boolean isAllSpace() {
        return this.isAllSpace;
    }

    public int displayAction(String spaceId) throws SpaceException {
        String userId;
        Space space;
        SpaceService spaceSrc = (SpaceService)this.getApplicationComponent(SpaceService.class);
        if (spaceSrc.isMember(space = spaceSrc.getSpace(spaceId), userId = Util.getPortalRequestContext().getRemoteUser())) {
            if (spaceSrc.isLeader(space, userId)) {
                return 2;
            }
            return 3;
        }
        if (spaceSrc.isPending(space, userId)) {
            return 1;
        }
        return 0;
    }

    public boolean isInInvitedList(Space space) {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        return spaceService.isInvited(space, userId);
    }

    static /* synthetic */ boolean access$002(UIManageSpaceWorkingArea x0, boolean x1) {
        x0.isAllSpace = x1;
        return x0.isAllSpace;
    }

    static /* synthetic */ boolean access$000(UIManageSpaceWorkingArea x0) {
        return x0.isAllSpace;
    }
}

